/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck.providers;

import org.mule.impl.RequestContext;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOMessageAdapter;

public abstract class AbstractMessageAdapterTestCase
extends AbstractMuleTestCase {
    protected void doSetUp() throws Exception {
        RequestContext.setEvent(AbstractMessageAdapterTestCase.getTestEvent("hello"));
    }

    protected void doTearDown() throws Exception {
        RequestContext.clear();
    }

    protected void doTestMessageEqualsPayload(Object message, Object payload) throws Exception {
        AbstractMessageAdapterTestCase.assertEquals(message, payload);
    }

    public void testMessageRetrieval() throws Exception {
        Object message = this.getValidMessage();
        UMOMessageAdapter adapter = this.createAdapter(message);
        this.doTestMessageEqualsPayload(message, adapter.getPayload());
        byte[] bytes = adapter.getPayloadAsBytes();
        AbstractMessageAdapterTestCase.assertNotNull(bytes);
        String stringMessage = adapter.getPayloadAsString();
        AbstractMessageAdapterTestCase.assertNotNull(stringMessage);
        AbstractMessageAdapterTestCase.assertNotNull(adapter.getPayload());
        try {
            adapter = this.createAdapter(this.getInvalidMessage());
            AbstractMessageAdapterTestCase.fail("Message adapter should throw MessageTypeNotSupportedException if an invalid message is set");
        }
        catch (MessageTypeNotSupportedException e) {
            // empty catch block
        }
    }

    public void testMessageProps() throws Exception {
        UMOMessageAdapter adapter = this.createAdapter(this.getValidMessage());
        adapter.setProperty("TestString", "Test1");
        adapter.setProperty("TestLong", new Long(20000000L));
        adapter.setProperty("TestInt", new Integer(200000));
        AbstractMessageAdapterTestCase.assertNotNull(adapter.getPropertyNames());
        Object prop = adapter.getProperty("TestString");
        AbstractMessageAdapterTestCase.assertNotNull(prop);
        AbstractMessageAdapterTestCase.assertEquals((Object)"Test1", prop);
        prop = adapter.getProperty("TestLong");
        AbstractMessageAdapterTestCase.assertNotNull(prop);
        AbstractMessageAdapterTestCase.assertEquals(new Long(20000000L), prop);
        prop = adapter.getProperty("TestInt");
        AbstractMessageAdapterTestCase.assertNotNull(prop);
        AbstractMessageAdapterTestCase.assertEquals(new Integer(200000), prop);
    }

    public Object getInvalidMessage() {
        return new InvalidMessage();
    }

    public abstract Object getValidMessage() throws Exception;

    public abstract UMOMessageAdapter createAdapter(Object var1) throws MessagingException;

    final class InvalidMessage {
        InvalidMessage() {
        }

        public String toString() {
            return "invalid message";
        }
    }
}

