/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dbfill;

import org.ow2.jasmine.monitoring.tests.dbfill.DbFillConfig;
import org.ow2.jasmine.monitoring.tests.dbfill.EjbPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.IPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEvent;
import org.ow2.jasmine.monitoring.tests.dbfill.JTEventConfig;
import org.ow2.jasmine.monitoring.tests.dbfill.JdbcPublisher;
import org.ow2.jasmine.monitoring.tests.dbfill.MulePublisher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class Cmd {
    static final String PUBLISHER_TYPE_PROPERTY_NAME = "publisher.type";
    static final String PUBLISHER_TYPE_EJB = "ejb";
    static final String PUBLISHER_TYPE_MULE = "mule";
    static final String PUBLISHER_TYPE_JDBC = "jdbc";
    static final String DEFAULT_PUBLISHER_TYPE = "ejb";
    private static Log logger = LogFactory.getLog(Cmd.class);

    public static void main(String[] args) {
        IPublisher publisher;
        if (args.length > 0 && "-help".equals(args[0])) {
            Cmd.usage();
            return;
        }
        logger.info((Object)">> Beginning of fill database.", new Object[0]);
        String publisherType = System.getProperty(PUBLISHER_TYPE_PROPERTY_NAME, "ejb");
        logger.info((Object)(">> Publisher type = " + publisherType.toUpperCase()), new Object[0]);
        if (publisherType.equalsIgnoreCase("ejb")) {
            publisher = new EjbPublisher();
        } else if (publisherType.equalsIgnoreCase(PUBLISHER_TYPE_MULE)) {
            publisher = new MulePublisher();
        } else if (publisherType.equalsIgnoreCase(PUBLISHER_TYPE_JDBC)) {
            publisher = new JdbcPublisher();
        } else {
            logger.error((Object)"ERROR: unknown publisher type", new Object[0]);
            throw new Error("unknown publisher type");
        }
        DbFillConfig config = new DbFillConfig();
        long timeTo = config.getTimeFrom();
        long timeFrom = config.getTimeTo();
        String domain = config.getDomain();
        String server = config.getServer();
        String sName = config.getSName();
        String source = config.getSource();
        for (JTEventConfig eventConfig : config.getEventConfigList()) {
            long timeCurrent;
            logger.info((Object)(">> Publish datas for the event config.: " + eventConfig.toString()), new Object[0]);
            int n = eventConfig.getVDeltaNeg() * (eventConfig.getVMax() - eventConfig.getVMin());
            int d = eventConfig.getVDeltaPos() + eventConfig.getVDeltaNeg();
            int value = d != 0 ? eventConfig.getVMin() + n / d : (eventConfig.getVMax() + eventConfig.getVMin()) / 2;
            JTEvent event = new JTEvent(domain, server, sName, source, eventConfig.getProbeId(), eventConfig.getMBean(), eventConfig.getVName(), timeCurrent, Integer.valueOf(value));
            for (timeCurrent = timeTo; timeCurrent <= timeFrom; timeCurrent += (long)(eventConfig.getPeriod() * 1000)) {
                event.setTime(timeCurrent);
                event.setValue(Integer.valueOf(value));
                publisher.publishData(event);
                logger.debug((Object)(">> Published event.: " + event.toString()), new Object[0]);
                int prevValue = value;
                value = JTEvent.computeNextValue(eventConfig.getVMin(), eventConfig.getVMax(), eventConfig.getVDeltaNeg(), eventConfig.getVDeltaPos(), prevValue);
            }
        }
        publisher.close();
        logger.info((Object)">> End of fill database.", new Object[0]);
    }

    static void usage() {
        System.out.println("");
        System.out.println("Usage:");
        System.out.println("");
        System.out.println("  java [ property ]* -jar ..../dbfill-${VERSION}-jar-with-dependencies.jar");
        System.out.println("");
        System.out.println("    -Ddbfill.config=/path/my-configfile.xml (default dbfill-config.xml in the dbfill jar file)");
        System.out.println("    -Dpublisher.type=[ejb|mule|jdbc]        (default 'ejb')");
        System.out.println("    ");
        System.out.println("    if publisher.type=ejb:");
        System.out.println("     -Dsmart.host=<host> (default 'localhost')");
        System.out.println("     -Dsmart.port=<port> (default '2503')");
        System.out.println("    ");
        System.out.println("    if publisher.type=mule:");
        System.out.println("     -Djprobe.dispatcher.host=<host> (default 'localhost')");
        System.out.println("     -Djprobe.dispatcher.port=<port> (default '18564')");
        System.out.println("    ");
        System.out.println("    if publisher.type=jdbc:");
        System.out.println("     -Djdbc.url=<url>       (default 'jdbc:h2:tcp://localhost:19001/db_jonas')");
        System.out.println("     -Djdbc.user=<user>     (default 'jonas')");
        System.out.println("     -Djdbc.passwd=<passwd> (default 'jonas')");
        System.out.println("");
    }
}

