/*
 * Decompiled with CFR 0.152.
 */
package com.mockobjects.util;

import com.mockobjects.Verifiable;
import com.mockobjects.util.NotImplementedException;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class AssertMo
extends Assert {
    protected AssertMo() {
    }

    public static void assertEquals(String description, Object[] expectedArray, Object[] actualArray) {
        Assert.assertEquals(description + " (different lengths)", expectedArray.length, actualArray.length);
        int i = 0;
        while (i < expectedArray.length) {
            Assert.assertEquals(description + " (element " + i + ")", expectedArray[i], actualArray[i]);
            ++i;
        }
    }

    public static void assertExcludes(String description, String excludeString, String targetString) {
        Assert.assertTrue(description + "\nExclude String: " + excludeString + "\n Target String: " + targetString, targetString.indexOf(excludeString) == -1);
    }

    public static void assertIncludes(String description, String includeString, String targetString) {
        Assert.assertTrue(description + "\nInclude String: " + includeString + "\n Target String: " + targetString, targetString.indexOf(includeString) != -1);
    }

    public static void assertStartsWith(String description, String startString, String targetString) {
        Assert.assertTrue(description + "\n Start String: " + startString + "\nTarget String: " + targetString, targetString.startsWith(startString));
    }

    public static void assertVerifyFails(Verifiable aVerifiable) {
        boolean threwException = false;
        try {
            aVerifiable.verify();
        }
        catch (AssertionFailedError ex) {
            threwException = true;
        }
        Assert.assertTrue("Should not have verified", threwException);
    }

    protected static void failNotEquals(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + "\nExpected:<" + expected + ">\nReceived:<" + actual + ">");
    }

    public static void notImplemented(String mockName) {
        throw new NotImplementedException("Not Implemented in " + mockName);
    }

    public static void assertFails(String message, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (AssertionFailedError expected) {
            return;
        }
        Assert.fail(message);
    }
}

