/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.extension;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.extension.DeweyDecimal;
import org.apache.tools.ant.taskdefs.optional.extension.Extension;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Reference;

public class ExtensionAdapter
extends DataType {
    private String extensionName;
    private DeweyDecimal specificationVersion;
    private String specificationVendor;
    private String implementationVendorID;
    private String implementationVendor;
    private DeweyDecimal implementationVersion;
    private String implementationURL;

    public void setExtensionName(String extensionName) {
        this.verifyNotAReference();
        this.extensionName = extensionName;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this.verifyNotAReference();
        this.specificationVersion = new DeweyDecimal(specificationVersion);
    }

    public void setSpecificationVendor(String specificationVendor) {
        this.verifyNotAReference();
        this.specificationVendor = specificationVendor;
    }

    public void setImplementationVendorId(String implementationVendorID) {
        this.verifyNotAReference();
        this.implementationVendorID = implementationVendorID;
    }

    public void setImplementationVendor(String implementationVendor) {
        this.verifyNotAReference();
        this.implementationVendor = implementationVendor;
    }

    public void setImplementationVersion(String implementationVersion) {
        this.verifyNotAReference();
        this.implementationVersion = new DeweyDecimal(implementationVersion);
    }

    public void setImplementationUrl(String implementationURL) {
        this.verifyNotAReference();
        this.implementationURL = implementationURL;
    }

    public void setRefid(Reference reference) throws BuildException {
        if (null != this.extensionName || null != this.specificationVersion || null != this.specificationVendor || null != this.implementationVersion || null != this.implementationVendorID || null != this.implementationVendor || null != this.implementationURL) {
            throw this.tooManyAttributes();
        }
        Object o = reference.getReferencedObject(this.getProject());
        if (!(o instanceof ExtensionAdapter)) {
            String message = reference.getRefId() + " doesn't refer to a Extension";
            throw new BuildException(message);
        }
        ExtensionAdapter other = (ExtensionAdapter)o;
        this.extensionName = other.extensionName;
        this.specificationVersion = other.specificationVersion;
        this.specificationVendor = other.specificationVendor;
        this.implementationVersion = other.implementationVersion;
        this.implementationVendorID = other.implementationVendorID;
        this.implementationVendor = other.implementationVendor;
        this.implementationURL = other.implementationURL;
        super.setRefid(reference);
    }

    private void verifyNotAReference() throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
    }

    Extension toExtension() throws BuildException {
        if (null == this.extensionName) {
            String message = "Extension is missing name.";
            throw new BuildException("Extension is missing name.");
        }
        String specificationVersionString = null;
        if (null != this.specificationVersion) {
            specificationVersionString = this.specificationVersion.toString();
        }
        String implementationVersionString = null;
        if (null != this.implementationVersion) {
            implementationVersionString = this.implementationVersion.toString();
        }
        return new Extension(this.extensionName, specificationVersionString, this.specificationVendor, implementationVersionString, this.implementationVendor, this.implementationVendorID, this.implementationURL);
    }

    public String toString() {
        return "{" + this.toExtension().toString() + "}";
    }
}

