/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.mvel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.base.mvel.MVELDebugHandler;
import org.drools.rule.MVELDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.spi.ProcessContext;
import org.drools.spi.ReturnValueEvaluator;
import org.mvel2.MVEL;
import org.mvel2.compiler.CompiledExpression;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.SimpleValueResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVELReturnValueEvaluator
implements ReturnValueEvaluator,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 400L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;
    private DroolsMVELFactory prototype;
    private List<String> variableNames;

    public MVELReturnValueEvaluator() {
    }

    public MVELReturnValueEvaluator(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public void setVariableNames(List<String> variableNames) {
        this.variableNames = variableNames;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
        this.variableNames = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
        out.writeObject(this.variableNames);
    }

    @Override
    public void compile(ClassLoader classLoader) {
        this.expr = this.unit.getCompiledExpression(classLoader);
        this.prototype = this.unit.getFactory();
    }

    public String getDialect() {
        return this.id;
    }

    @Override
    public Object evaluate(WorkingMemory workingMemory, ProcessContext context) throws Exception {
        DroolsMVELFactory factory = (DroolsMVELFactory)this.prototype.clone();
        factory.addResolver("context", new SimpleValueResolver(context));
        factory.addResolver("kcontext", new SimpleValueResolver(context));
        if (this.variableNames != null) {
            for (String variableName : this.variableNames) {
                factory.addResolver(variableName, new SimpleValueResolver(context.getVariable(variableName)));
            }
        }
        factory.setContext(null, null, null, workingMemory, null);
        Package pkg = workingMemory.getRuleBase().getPackage("MAIN");
        if (pkg != null) {
            MVELDialectRuntimeData data = (MVELDialectRuntimeData)pkg.getDialectRuntimeRegistry().getDialectData(this.id);
            factory.setNextFactory(data.getFunctionFactory());
        }
        CompiledExpression compexpr = (CompiledExpression)this.expr;
        Object value = MVELDebugHandler.isDebugMode() ? MVEL.executeDebugger(compexpr, null, factory) : MVEL.executeExpression((Object)compexpr, null, (VariableResolverFactory)factory);
        if (!(value instanceof Boolean)) {
            throw new RuntimeException("Constraints must return boolean values");
        }
        return (boolean)((Boolean)value);
    }

    public Serializable getCompExpr() {
        return this.expr;
    }

    public String toString() {
        return this.unit.getExpression();
    }
}

