/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.drools.definition.rule.Rule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializedRule
implements Rule,
Externalizable {
    private String name;
    private String packageName;
    private Map<String, String> metaAttributes;

    public SerializedRule() {
    }

    public SerializedRule(Rule rule) {
        this.name = rule.getName();
        this.packageName = rule.getPackageName();
        Collection<String> identifiers = rule.listMetaAttributes();
        this.metaAttributes = new HashMap<String, String>(identifiers.size());
        for (String identifier : identifiers) {
            this.metaAttributes.put(identifier, rule.getMetaAttribute(identifier));
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.packageName);
        out.writeObject(this.metaAttributes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.packageName = in.readUTF();
        this.metaAttributes = (Map)in.readObject();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getMetaAttribute(String identifier) {
        return this.metaAttributes.get(identifier);
    }

    @Override
    public Collection<String> listMetaAttributes() {
        return this.metaAttributes.keySet();
    }
}

