/*
 * Decompiled with CFR 0.152.
 */
package org.drools.jsr94.rules.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.rules.admin.LocalRuleExecutionSetProvider;
import javax.rules.admin.RuleExecutionSet;
import javax.rules.admin.RuleExecutionSetCreateException;
import org.drools.IntegrationException;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.SpreadsheetCompiler;
import org.drools.jsr94.rules.admin.RuleExecutionSetImpl;
import org.drools.rule.Package;

public class LocalRuleExecutionSetProviderImpl
implements LocalRuleExecutionSetProvider {
    public RuleExecutionSet createRuleExecutionSet(InputStream ruleExecutionSetStream, Map properties) throws RuleExecutionSetCreateException {
        if (properties != null) {
            String source = (String)properties.get("javax.rules.admin.RuleExecutionSet.source");
            if (source == null) {
                source = (String)properties.get("source");
            }
            if (source != null && source.equals("javax.rules.admin.RuleExecutionSet.source.decisiontable")) {
                SpreadsheetCompiler converter = new SpreadsheetCompiler();
                String drl = converter.compile(ruleExecutionSetStream, InputType.XLS);
                return this.createRuleExecutionSet(new StringReader(drl), properties);
            }
            return this.createRuleExecutionSet(new InputStreamReader(ruleExecutionSetStream), properties);
        }
        return this.createRuleExecutionSet(new InputStreamReader(ruleExecutionSetStream), properties);
    }

    public RuleExecutionSet createRuleExecutionSet(Reader ruleExecutionSetReader, Map properties) throws RuleExecutionSetCreateException {
        try {
            PackageBuilderConfiguration config = null;
            if (properties != null) {
                config = (PackageBuilderConfiguration)properties.get("javax.rules.admin.RuleExecutionSet.packageBuilderConfiguration");
            }
            PackageBuilder builder = null;
            builder = config != null ? new PackageBuilder(config) : new PackageBuilder();
            Object dsrl = null;
            String source = null;
            if (properties != null) {
                dsrl = properties.get("javax.rules.admin.RuleExecutionSet.dsl");
                if (dsrl == null) {
                    dsrl = properties.get("dsl");
                }
                if ((source = (String)properties.get("javax.rules.admin.RuleExecutionSet.source")) == null) {
                    source = (String)properties.get("source");
                }
            }
            if (source == null) {
                source = "drl";
            }
            if (dsrl == null) {
                if (source.equals("javax.rules.admin.RuleExecutionSet.source.xml") || source.equals("xml")) {
                    builder.addPackageFromXml(ruleExecutionSetReader);
                } else {
                    builder.addPackageFromDrl(ruleExecutionSetReader);
                }
            } else if (source.equals("javax.rules.admin.RuleExecutionSet.source.xml") || source.equals("xml")) {
                builder.addPackageFromXml(ruleExecutionSetReader);
            } else if (dsrl instanceof Reader) {
                builder.addPackageFromDrl(ruleExecutionSetReader, dsrl);
            } else {
                builder.addPackageFromDrl(ruleExecutionSetReader, new StringReader(dsrl));
            }
            Package pkg = builder.getPackage();
            return this.createRuleExecutionSet(pkg, properties);
        }
        catch (IOException e) {
            throw new RuleExecutionSetCreateException("cannot create rule execution set", e);
        }
        catch (DroolsParserException e) {
            throw new RuleExecutionSetCreateException("cannot create rule execution set", e);
        }
    }

    public RuleExecutionSet createRuleExecutionSet(Object ruleExecutionSetAst, Map properties) throws RuleExecutionSetCreateException {
        if (ruleExecutionSetAst instanceof Package) {
            Package pkg = (Package)ruleExecutionSetAst;
            return this.createRuleExecutionSet(pkg, properties);
        }
        throw new RuleExecutionSetCreateException(" Incoming AST object must be an org.drools.rule.Package.  Was " + ruleExecutionSetAst.getClass());
    }

    private RuleExecutionSet createRuleExecutionSet(Package pkg, Map properties) throws RuleExecutionSetCreateException {
        try {
            return new RuleExecutionSetImpl(pkg, properties);
        }
        catch (IntegrationException e) {
            throw new RuleExecutionSetCreateException("Failed to create RuleExecutionSet", e);
        }
    }
}

