/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.Agenda;
import org.drools.WorkingMemory;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.definition.process.Process;
import org.drools.process.core.Context;
import org.drools.process.core.ContextContainer;
import org.drools.process.instance.ContextInstance;
import org.drools.process.instance.ProcessInstance;
import org.drools.process.instance.impl.ContextInstanceFactory;
import org.drools.process.instance.impl.ContextInstanceFactoryRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProcessInstanceImpl
implements ProcessInstance,
Serializable {
    private static final long serialVersionUID = 4L;
    private long id;
    private String processId;
    private transient Process process;
    private int state = 0;
    private Map<String, ContextInstance> contextInstances = new HashMap<String, ContextInstance>();
    private Map<String, List<ContextInstance>> subContextInstances = new HashMap<String, List<ContextInstance>>();
    private InternalWorkingMemory workingMemory;

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setProcess(Process process) {
        this.processId = process.getId();
        this.process = process;
    }

    @Override
    public Process getProcess() {
        if (this.process == null) {
            this.process = ((InternalRuleBase)this.workingMemory.getRuleBase()).getProcess(this.processId);
        }
        return this.process;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Override
    public String getProcessId() {
        return this.processId;
    }

    @Override
    public String getProcessName() {
        return this.getProcess().getName();
    }

    @Override
    public void setState(int state) {
        this.internalSetState(state);
    }

    public void internalSetState(int state) {
        this.state = state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        if (this.workingMemory != null) {
            throw new IllegalArgumentException("A working memory can only be set once.");
        }
        this.workingMemory = workingMemory;
    }

    @Override
    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    @Override
    public Agenda getAgenda() {
        if (this.getWorkingMemory() == null) {
            return null;
        }
        return this.getWorkingMemory().getAgenda();
    }

    @Override
    public ContextContainer getContextContainer() {
        return (ContextContainer)((Object)this.getProcess());
    }

    public void setContextInstance(String contextId, ContextInstance contextInstance) {
        this.contextInstances.put(contextId, contextInstance);
    }

    @Override
    public ContextInstance getContextInstance(String contextId) {
        ContextInstance contextInstance = this.contextInstances.get(contextId);
        if (contextInstance != null) {
            return contextInstance;
        }
        Context context = ((ContextContainer)((Object)this.getProcess())).getDefaultContext(contextId);
        if (context != null) {
            contextInstance = this.getContextInstance(context);
            return contextInstance;
        }
        return null;
    }

    @Override
    public List<ContextInstance> getContextInstances(String contextId) {
        return this.subContextInstances.get(contextId);
    }

    @Override
    public void addContextInstance(String contextId, ContextInstance contextInstance) {
        List<ContextInstance> list = this.subContextInstances.get(contextId);
        if (list == null) {
            list = new ArrayList<ContextInstance>();
            this.subContextInstances.put(contextId, list);
        }
        list.add(contextInstance);
    }

    @Override
    public ContextInstance getContextInstance(String contextId, long id) {
        List<ContextInstance> contextInstances = this.subContextInstances.get(contextId);
        if (contextInstances != null) {
            for (ContextInstance contextInstance : contextInstances) {
                if (contextInstance.getContextId() != id) continue;
                return contextInstance;
            }
        }
        return null;
    }

    @Override
    public ContextInstance getContextInstance(Context context) {
        ContextInstanceFactoryRegistry contextRegistry = ((InternalRuleBase)this.getWorkingMemory().getRuleBase()).getConfiguration().getProcessContextInstanceFactoryRegistry();
        ContextInstanceFactory conf = contextRegistry.getContextInstanceFactory(context);
        if (conf == null) {
            throw new IllegalArgumentException("Illegal context type (registry not found): " + context.getClass());
        }
        ContextInstance contextInstance = conf.getContextInstance(context, this, this);
        if (contextInstance == null) {
            throw new IllegalArgumentException("Illegal context type (instance not found): " + context.getClass());
        }
        return contextInstance;
    }

    @Override
    public void signalEvent(String type, Object event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        ProcessInstanceImpl processInstanceImpl = this;
        synchronized (processInstanceImpl) {
            if (this.getState() != 0) {
                throw new IllegalArgumentException("A process instance can only be started once");
            }
            this.setState(1);
            this.internalStart();
        }
    }

    protected abstract void internalStart();

    public void disconnect() {
        this.workingMemory.getProcessInstanceManager().internalRemoveProcessInstance(this);
        this.process = null;
        this.workingMemory = null;
    }

    public void reconnect() {
        this.workingMemory.getProcessInstanceManager().internalAddProcessInstance(this);
    }

    @Override
    public String[] getEventTypes() {
        return null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ProcessInstance ");
        b.append(this.getId());
        b.append(" [processId=");
        b.append(this.process.getId());
        b.append(",state=");
        b.append(this.state);
        b.append("]");
        return b.toString();
    }
}

