/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ruleflow.core.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.definition.process.Connection;
import org.drools.definition.process.Node;
import org.drools.definition.process.Process;
import org.drools.process.core.Work;
import org.drools.process.core.context.variable.Variable;
import org.drools.process.core.validation.ProcessValidationError;
import org.drools.process.core.validation.ProcessValidator;
import org.drools.process.core.validation.impl.ProcessValidationErrorImpl;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.EventNode;
import org.drools.workflow.core.node.FaultNode;
import org.drools.workflow.core.node.ForEachNode;
import org.drools.workflow.core.node.Join;
import org.drools.workflow.core.node.MilestoneNode;
import org.drools.workflow.core.node.RuleSetNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.WorkItemNode;
import org.mvel2.ErrorDetail;
import org.mvel2.ParserContext;
import org.mvel2.compiler.ExpressionCompiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowProcessValidator
implements ProcessValidator {
    private static RuleFlowProcessValidator instance;
    private boolean startNodeFound;
    private boolean endNodeFound;

    private RuleFlowProcessValidator() {
    }

    public static RuleFlowProcessValidator getInstance() {
        if (instance == null) {
            instance = new RuleFlowProcessValidator();
        }
        return instance;
    }

    public ProcessValidationError[] validateProcess(RuleFlowProcess process) {
        ArrayList<ProcessValidationError> errors = new ArrayList<ProcessValidationError>();
        if (process.getName() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no name."));
        }
        if (process.getId() == null || "".equals(process.getId())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no id."));
        }
        if (process.getPackageName() == null || "".equals(process.getPackageName())) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no package name."));
        }
        if (process.getStart() == null) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        this.startNodeFound = false;
        this.endNodeFound = false;
        Node[] nodes = process.getNodes();
        this.validateNodes(nodes, errors, process);
        if (!this.startNodeFound) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no start node."));
        }
        if (!this.endNodeFound) {
            errors.add(new ProcessValidationErrorImpl(process, "Process has no end node."));
        }
        for (Variable variable : process.getVariableScope().getVariables()) {
            if (variable.getType() != null) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Variable '" + variable.getName() + "' has no type."));
        }
        this.checkAllNodesConnectedToStart(process, errors);
        return errors.toArray(new ProcessValidationError[errors.size()]);
    }

    private void validateNodes(Node[] nodes, List<ProcessValidationError> errors, RuleFlowProcess process) {
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof StartNode) {
                StartNode startNode = (StartNode)node;
                this.startNodeFound = true;
                if (startNode.getTo() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Start node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                continue;
            }
            if (node instanceof EndNode) {
                EndNode endNode = (EndNode)node;
                this.endNodeFound = true;
                if (endNode.getFrom() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "End node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                continue;
            }
            if (node instanceof RuleSetNode) {
                String ruleFlowGroup;
                RuleSetNode ruleSetNode = (RuleSetNode)node;
                if (ruleSetNode.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (ruleSetNode.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if ((ruleFlowGroup = ruleSetNode.getRuleFlowGroup()) != null && !"".equals(ruleFlowGroup)) continue;
                errors.add(new ProcessValidationErrorImpl(process, "RuleSet node '" + node.getName() + "' [" + node.getId() + "] has no ruleflow-group."));
                continue;
            }
            if (node instanceof Split) {
                Split split = (Split)node;
                if (split.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (split.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (split.getDefaultOutgoingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have more than one outgoing connection: " + split.getOutgoingConnections().size() + "."));
                }
                if (split.getType() != 2 && split.getType() != 3) continue;
                for (Connection connection : split.getDefaultOutgoingConnections()) {
                    if (split.getConstraint(connection) != null) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Split node '" + node.getName() + "' [" + node.getId() + "] does not have a constraint for " + connection.toString() + "."));
                }
                continue;
            }
            if (node instanceof Join) {
                String n;
                Join join = (Join)node;
                if (join.getType() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no type."));
                }
                if (join.getDefaultIncomingConnections().size() < 2) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] does not have more than one incoming connection: " + join.getIncomingConnections().size() + "."));
                }
                if (join.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (join.getType() != 4 || (n = join.getN()).startsWith("#{") && n.endsWith("}")) continue;
                try {
                    new Integer(n);
                }
                catch (NumberFormatException e) {
                    errors.add(new ProcessValidationErrorImpl(process, "Join node '" + node.getName() + "' [" + node.getId() + "] has illegal n value: " + n));
                }
                continue;
            }
            if (node instanceof MilestoneNode) {
                MilestoneNode milestone = (MilestoneNode)node;
                if (milestone.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (milestone.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (milestone.getConstraint() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Milestone node '" + node.getName() + "' [" + node.getId() + "] has no constraint."));
                continue;
            }
            if (node instanceof SubProcessNode) {
                SubProcessNode subProcess = (SubProcessNode)node;
                if (subProcess.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (subProcess.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (subProcess.getProcessId() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "SubProcess node '" + node.getName() + "' [" + node.getId() + "] has no process id."));
                continue;
            }
            if (node instanceof ActionNode) {
                ActionNode actionNode = (ActionNode)node;
                if (actionNode.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (actionNode.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (actionNode.getAction() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has no action."));
                    continue;
                }
                if (!(actionNode.getAction() instanceof DroolsConsequenceAction)) continue;
                DroolsConsequenceAction droolsAction = (DroolsConsequenceAction)actionNode.getAction();
                String actionString = droolsAction.getConsequence();
                if (actionString == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has empty action."));
                    continue;
                }
                if (!"mvel".equals(droolsAction.getDialect())) continue;
                try {
                    ExpressionCompiler compiler = new ExpressionCompiler(actionString);
                    compiler.setVerifying(true);
                    ParserContext parserContext = new ParserContext();
                    compiler.compile(parserContext);
                    List<ErrorDetail> mvelErrors = parserContext.getErrorList();
                    if (mvelErrors == null) continue;
                    for (ErrorDetail error : mvelErrors) {
                        errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + error.getMessage() + "."));
                    }
                    continue;
                }
                catch (Throwable t) {
                    errors.add(new ProcessValidationErrorImpl(process, "Action node '" + node.getName() + "' [" + node.getId() + "] has invalid action: " + t.getMessage() + "."));
                    continue;
                }
            }
            if (node instanceof WorkItemNode) {
                WorkItemNode workItemNode = (WorkItemNode)node;
                if (workItemNode.getFrom() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
                }
                if (workItemNode.getTo() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection."));
                }
                if (workItemNode.getWork() == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work specified."));
                    continue;
                }
                Work work = workItemNode.getWork();
                if (work.getName() != null) continue;
                errors.add(new ProcessValidationErrorImpl(process, "WorkItem node '" + node.getName() + "' [" + node.getId() + "] has no work name."));
                continue;
            }
            if (node instanceof ForEachNode) {
                String collectionExpression;
                ForEachNode forEachNode = (ForEachNode)node;
                String variableName = forEachNode.getVariableName();
                if (variableName == null || "".equals(variableName)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no variable name"));
                }
                if ((collectionExpression = forEachNode.getCollectionExpression()) == null || "".equals(collectionExpression)) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no collection expression"));
                }
                if (forEachNode.getIncomingConnections("DROOLS_DEFAULT").size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection"));
                }
                if (forEachNode.getOutgoingConnections("DROOLS_DEFAULT").size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                }
                if (forEachNode.getLinkedIncomingNode("DROOLS_DEFAULT") == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no linked start node"));
                }
                if (forEachNode.getLinkedOutgoingNode("DROOLS_DEFAULT") == null) {
                    errors.add(new ProcessValidationErrorImpl(process, "ForEach node '" + node.getName() + "' [" + node.getId() + "] has no linked end node"));
                }
                this.validateNodes(forEachNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof CompositeNode) {
                CompositeNode compositeNode = (CompositeNode)node;
                for (Map.Entry<String, CompositeNode.NodeAndType> inType : compositeNode.getLinkedIncomingNodes().entrySet()) {
                    if (compositeNode.getIncomingConnections(inType.getKey()).size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection for type " + inType.getKey()));
                    }
                    if (inType.getValue().getNode() != null) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked incoming node for type " + inType.getKey()));
                }
                for (Map.Entry<String, CompositeNode.NodeAndType> outType : compositeNode.getLinkedOutgoingNodes().entrySet()) {
                    if (compositeNode.getOutgoingConnections(outType.getKey()).size() == 0) {
                        errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection for type " + outType.getKey()));
                    }
                    if (outType.getValue().getNode() != null) continue;
                    errors.add(new ProcessValidationErrorImpl(process, "Composite node '" + node.getName() + "' [" + node.getId() + "] has invalid linked outgoing node for type " + outType.getKey()));
                }
                this.validateNodes(compositeNode.getNodes(), errors, process);
                continue;
            }
            if (node instanceof EventNode) {
                EventNode eventNode = (EventNode)node;
                if (eventNode.getEventFilters().size() == 0) {
                    errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] should specify an event type"));
                }
                if (eventNode.getOutgoingConnections("DROOLS_DEFAULT").size() != 0) continue;
                errors.add(new ProcessValidationErrorImpl(process, "Event node '" + node.getName() + "' [" + node.getId() + "] has no outgoing connection"));
                continue;
            }
            if (!(node instanceof FaultNode)) continue;
            this.endNodeFound = true;
            FaultNode faultNode = (FaultNode)node;
            if (faultNode.getFrom() == null) {
                errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no incoming connection."));
            }
            if (faultNode.getFaultName() != null) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Fault node '" + node.getName() + "' [" + node.getId() + "] has no fault name."));
        }
    }

    private void checkAllNodesConnectedToStart(RuleFlowProcess process, List<ProcessValidationError> errors) {
        HashMap<Node, Boolean> processNodes = new HashMap<Node, Boolean>();
        Node[] nodes = process.getNodes();
        ArrayList<Node> eventNodes = new ArrayList<Node>();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            processNodes.put(node, Boolean.FALSE);
            if (!(node instanceof EventNode)) continue;
            eventNodes.add(node);
        }
        StartNode start = process.getStart();
        if (start != null) {
            this.processNode(start, processNodes);
        }
        for (Node eventNode : eventNodes) {
            this.processNode(eventNode, processNodes);
        }
        for (Node node : processNodes.keySet()) {
            if (!Boolean.FALSE.equals(processNodes.get(node))) continue;
            errors.add(new ProcessValidationErrorImpl(process, "Node '" + node.getName() + "' [" + node.getId() + "] has no connection to the start node."));
        }
    }

    private void processNode(Node node, Map<Node, Boolean> nodes) {
        if (!nodes.containsKey(node)) {
            throw new IllegalStateException("A process node is connected with a node that does not belong to the process: " + node.getName());
        }
        Boolean prevValue = nodes.put(node, Boolean.TRUE);
        if (prevValue == Boolean.FALSE) {
            for (List<Connection> list : node.getOutgoingConnections().values()) {
                Iterator<Connection> it2 = list.iterator();
                while (it2.hasNext()) {
                    this.processNode(it2.next().getTo(), nodes);
                }
            }
        }
    }

    @Override
    public ProcessValidationError[] validateProcess(Process process) {
        if (!(process instanceof RuleFlowProcess)) {
            throw new IllegalArgumentException("This validator can only validate ruleflow processes!");
        }
        return this.validateProcess((RuleFlowProcess)process);
    }
}

