/*
 * Decompiled with CFR 0.152.
 */
package org.drools.testframework;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.rule.Rule;
import org.drools.spi.Activation;
import org.drools.spi.AgendaFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestingEventListener
implements AgendaEventListener {
    final Map<String, Integer> firingCounts = new HashMap<String, Integer>(100);
    long totalFires;

    public AgendaFilter getAgendaFilter(final HashSet<String> ruleNames, final boolean inclusive) {
        return new AgendaFilter(){

            public boolean accept(Activation activation) {
                if (ruleNames.size() == 0) {
                    return true;
                }
                String ruleName = activation.getRule().getName();
                if (inclusive) {
                    return ruleNames.contains(ruleName);
                }
                return !ruleNames.contains(ruleName);
            }
        };
    }

    @Override
    public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
        this.recordFiring(event.getActivation().getRule());
    }

    private void recordFiring(Rule rule) {
        this.record(rule, this.firingCounts);
    }

    @Override
    public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
    }

    @Override
    public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
    }

    private void record(Rule rule, Map<String, Integer> counts) {
        ++this.totalFires;
        String name = rule.getName();
        if (!counts.containsKey(name)) {
            counts.put(name, 1);
        } else {
            counts.put(name, counts.get(name) + 1);
        }
    }

    public Map<String, Integer> getFiringCounts() {
        return this.firingCounts;
    }

    public String[] getRulesFiredSummary() {
        String[] r = new String[this.firingCounts.size()];
        int i = 0;
        for (Map.Entry<String, Integer> e : this.firingCounts.entrySet()) {
            r[i] = e.getKey() + " [" + e.getValue() + "]";
            ++i;
        }
        return r;
    }
}

