/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTree<K, V> {
    private Map<K, Set<V>> map = new TreeMap<K, Set<V>>();

    public void put(K key, V value) {
        if (this.map.containsKey(key)) {
            Set<V> set = this.map.get(key);
            set.add(value);
        } else {
            TreeSet<V> set = new TreeSet<V>();
            set.add(value);
            this.map.put(key, set);
        }
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public Set<V> getBranch(K key) {
        Set<V> set = this.map.get(key);
        if (set != null) {
            return set;
        }
        return Collections.emptySet();
    }

    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Set<V> set : this.map.values()) {
            for (V value : set) {
                values.add(value);
            }
        }
        return values;
    }

    public boolean remove(K key, V value) {
        Set<V> set = this.map.get(key);
        if (set != null) {
            return set.remove(value);
        }
        return false;
    }

    public String toString() {
        return this.values().toString();
    }
}

