/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.report.html;

import java.util.Collection;
import java.util.HashMap;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.components.Restriction;
import org.drools.verifier.components.RulePackage;
import org.drools.verifier.components.VerifierRule;
import org.drools.verifier.dao.VerifierData;
import org.drools.verifier.dao.VerifierResult;
import org.drools.verifier.report.components.RangeCheckCause;
import org.drools.verifier.report.html.MissingRangesReportVisitor;
import org.drools.verifier.report.html.ReportVisitor;
import org.mvel2.templates.TemplateRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentsReportVisitor
extends ReportVisitor {
    ComponentsReportVisitor() {
    }

    public static String getCss(String fileName) {
        return ComponentsReportVisitor.readFile(fileName);
    }

    public static String visitRulePackageCollection(String sourceFolder, Collection<RulePackage> packages) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFolder", sourceFolder);
        map.put("ruleFolder", "rules");
        map.put("rulePackages", packages);
        String myTemplate = ComponentsReportVisitor.readFile("packages.htm");
        String result = String.valueOf(TemplateRuntime.eval(myTemplate, map));
        return result;
    }

    public static String visitObjectTypeCollection(String sourceFolder, Collection<ObjectType> objectTypes) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFolder", sourceFolder);
        map.put("objectTypeFolder", sourceFolder + "/" + "objectTypes");
        map.put("fieldFolder", "fields");
        map.put("objectTypes", objectTypes);
        String myTemplate = ComponentsReportVisitor.readFile("objectTypes.htm");
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }

    public static String visitRule(String sourceFolder, VerifierRule rule, VerifierData data) {
        Collection<ObjectType> objectTypes = data.getObjectTypesByRuleName(rule.getRuleName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFolder", sourceFolder);
        map.put("objectTypeFolder", "objectTypes");
        map.put("rule", rule);
        map.put("objectTypes", objectTypes);
        String myTemplate = ComponentsReportVisitor.readFile("rule.htm");
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }

    public static String visitObjectType(String sourceFolder, ObjectType objectType, VerifierData data) {
        Collection<VerifierRule> rules = data.getRulesByObjectTypeId(objectType.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFolder", sourceFolder);
        map.put("ruleFolder", "rules");
        map.put("fieldFolder", "fields");
        map.put("objectType", objectType);
        map.put("rules", rules);
        String myTemplate = ComponentsReportVisitor.readFile("objectType.htm");
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }

    public static String visitField(String sourceFolder, Field field, VerifierResult result) {
        VerifierData data = result.getVerifierData();
        ObjectType objectType = data.getObjectTypeById(field.getObjectTypeId());
        Collection<VerifierRule> rules = data.getRulesByFieldId(field.getId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceFolder", sourceFolder);
        map.put("ruleFolder", "rules");
        map.put("objectTypeFolder", "objectTypes");
        map.put("fieldFolder", "fields");
        map.put("field", field);
        map.put("objectType", objectType);
        map.put("rules", rules);
        if (field.getFieldType() == Field.FieldType.DOUBLE || field.getFieldType() == Field.FieldType.DATE || field.getFieldType() == Field.FieldType.INT) {
            Collection<RangeCheckCause> causes = result.getRangeCheckCausesByFieldId(field.getId());
            Collection<Restriction> restrictions = data.getRestrictionsByFieldId(field.getId());
            map.put("ranges", "Ranges:" + MissingRangesReportVisitor.visitRanges("..", restrictions, causes));
        } else {
            map.put("ranges", "");
        }
        String myTemplate = ComponentsReportVisitor.readFile("field.htm");
        return String.valueOf(TemplateRuntime.eval(myTemplate, map));
    }
}

