/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import [Ljava.lang.Object;;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.MuleMessage;
import org.mule.impl.NoSatisfiableMethodsException;
import org.mule.impl.OptimizedRequestContext;
import org.mule.impl.TooManySatisfiableMethodsException;
import org.mule.impl.VoidResult;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOEventContext;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.model.UMOEntryPoint;
import org.mule.util.ClassUtils;

public class DynamicEntryPoint
implements UMOEntryPoint {
    protected static final Log logger = LogFactory.getLog(DynamicEntryPoint.class);
    protected static final Set IgnoredMethodNames = new HashSet<String>(Arrays.asList("equals", "getInvocationHandler"));
    private final ConcurrentMap entryPoints = new ConcurrentHashMap();

    protected Method addMethodByArgumentType(Method method, String payloadClass) {
        Method previousMethod = (Method)this.entryPoints.putIfAbsent(payloadClass, method);
        return previousMethod != null ? previousMethod : method;
    }

    protected Method addMethodByName(Method method, String payloadClass) {
        Method previousMethod;
        ConcurrentMap previousTypes;
        String methodName = method.getName();
        ConcurrentMap argumentTypes = (ConcurrentMap)this.entryPoints.get(methodName);
        if (argumentTypes == null && (previousTypes = (ConcurrentMap)this.entryPoints.putIfAbsent(methodName, argumentTypes = new ConcurrentHashMap())) != null) {
            argumentTypes = previousTypes;
        }
        return (previousMethod = (Method)argumentTypes.putIfAbsent(payloadClass, method)) != null ? previousMethod : method;
    }

    protected Method getMethodByArgumentType(String argumentType) {
        return (Method)this.entryPoints.get(argumentType);
    }

    protected Method getMethodByName(String methodName, String argumentType) {
        ConcurrentMap argumentTypes = (ConcurrentMap)this.entryPoints.get(methodName);
        return argumentTypes != null ? (Method)argumentTypes.get(argumentType) : null;
    }

    public Object invoke(Object component, UMOEventContext context) throws Exception {
        Method method = null;
        Object payload = null;
        boolean ignoreMethod = BooleanUtils.toBoolean((Boolean)context.getMessage().removeProperty("MULE_IGNORE_METHOD"));
        if (!ignoreMethod) {
            Object methodOverride = context.getMessage().removeProperty("method");
            if (methodOverride instanceof Method) {
                method = (Method)methodOverride;
            } else if (methodOverride != null) {
                payload = context.getTransformedMessage();
                String payloadClassName = payload.getClass().getName();
                String methodOverrideName = methodOverride.toString();
                method = this.getMethodByName(methodOverrideName, payloadClassName);
                if (method == null) {
                    List matchingMethods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, IgnoredMethodNames);
                    Iterator i = matchingMethods.iterator();
                    while (i.hasNext()) {
                        Method candidate = (Method)i.next();
                        if (!candidate.getName().equals(methodOverride)) continue;
                        method = candidate;
                        break;
                    }
                    this.validateMethod(component, method, methodOverrideName);
                    if (method != null) {
                        method = this.addMethodByName(method, payloadClassName);
                    }
                }
            }
        }
        if (method == null) {
            if (component instanceof Callable) {
                method = Callable.class.getMethods()[0];
                payload = context;
            } else {
                method = this.getMethodByArgumentType(context.getClass().getName());
                if (method == null) {
                    payload = context.getTransformedMessage();
                    method = this.getMethodByArgumentType(payload.getClass().getName());
                    if (method != null) {
                        OptimizedRequestContext.unsafeRewriteEvent(new MuleMessage(payload, context.getMessage()));
                    }
                } else {
                    payload = context;
                }
            }
        }
        if (method == null) {
            List methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(context), true, false, IgnoredMethodNames);
            int numMethods = methods.size();
            if (numMethods > 1) {
                TooManySatisfiableMethodsException tmsmex = new TooManySatisfiableMethodsException(component.getClass(), methods);
                throw new InvocationTargetException(tmsmex, "There must be only one method accepting " + context.getClass().getName() + " in component " + component.getClass().getName());
            }
            if (numMethods == 1) {
                payload = context;
                method = this.addMethodByArgumentType((Method)methods.get(0), payload.getClass().getName());
            } else {
                payload = context.getTransformedMessage();
                OptimizedRequestContext.unsafeRewriteEvent(new MuleMessage(payload, context.getMessage()));
                methods = ClassUtils.getSatisfiableMethods(component.getClass(), ClassUtils.getClassTypes(payload), true, true, IgnoredMethodNames);
                numMethods = methods.size();
                if (numMethods > 1) {
                    throw new TooManySatisfiableMethodsException(component.getClass(), methods);
                }
                if (numMethods == 1) {
                    method = this.addMethodByArgumentType((Method)methods.get(0), payload.getClass().getName());
                } else {
                    throw new NoSatisfiableMethodsException(component.getClass(), ClassUtils.getClassTypes(payload));
                }
            }
        }
        if (payload == null) {
            payload = context.getTransformedMessage();
            OptimizedRequestContext.unsafeRewriteEvent(new MuleMessage(payload, context.getMessage()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Dynamic Entrypoint using method: " + component.getClass().getName() + "." + method.getName() + "(" + payload.getClass().getName() + ")");
        }
        return this.invokeMethod(component, method, payload);
    }

    protected Object invokeMethod(Object component, Method method, Object argument) throws InvocationTargetException, IllegalAccessException {
        String methodCall = null;
        if (logger.isDebugEnabled()) {
            methodCall = component.getClass().getName() + "." + method.getName() + "(" + argument.getClass().getName() + ")";
            logger.debug("Invoking " + methodCall);
        }
        Object[] invocationArgs = argument.getClass().isArray() ? (Object;.class.isAssignableFrom(argument.getClass()) ? (Object[])argument : new Object[]{argument}) : (argument instanceof NullPayload ? null : new Object[]{argument});
        Object result = method.invoke(component, invocationArgs);
        if (method.getReturnType().equals(Void.TYPE)) {
            result = VoidResult.getInstance();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Result of call " + methodCall + " is " + (result == null ? "null" : "not null"));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateMethod(Object component, Method method, String methodName) throws NoSuchMethodException {
        boolean fallback = component instanceof Callable;
        if (method != null) {
            try {
                component.getClass().getMethod(method.getName(), method.getParameterTypes());
                return;
            }
            catch (NoSuchMethodException e) {
                if (fallback) return;
                throw e;
            }
        } else {
            if (fallback) return;
            throw new NoSuchMethodException(CoreMessages.methodWithParamsNotFoundOnObject(methodName, "unknown", component.getClass()).toString());
        }
    }
}

