/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.routing.AbstractRouter;
import org.mule.routing.CorrelationPropertiesExtractor;
import org.mule.umo.UMOMessage;
import org.mule.umo.routing.UMOResponseRouter;
import org.mule.util.ClassUtils;
import org.mule.util.properties.PropertyExtractor;

public abstract class AbstractResponseRouter
extends AbstractRouter
implements UMOResponseRouter {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private int timeout = 10000;
    private boolean failOnTimeout = true;
    protected PropertyExtractor correlationExtractor = new CorrelationPropertiesExtractor();

    public PropertyExtractor getCorrelationExtractor() {
        return this.correlationExtractor;
    }

    public void setCorrelationExtractor(PropertyExtractor correlationExtractor) {
        this.correlationExtractor = correlationExtractor;
    }

    public void setPropertyExtractorAsString(String className) {
        try {
            this.correlationExtractor = (PropertyExtractor)ClassUtils.instanciateClass(className, null, this.getClass());
        }
        catch (Exception ex) {
            throw (IllegalArgumentException)new IllegalArgumentException("Couldn't instanciate property extractor class " + className).initCause(ex);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected Object getReplyAggregateIdentifier(UMOMessage message) {
        return this.correlationExtractor.getProperty("MULE_CORRELATION_ID", message);
    }

    protected Object getCallResponseAggregateIdentifier(UMOMessage message) {
        return this.correlationExtractor.getProperty("MULE_MESSAGE_ID", message);
    }

    public boolean isFailOnTimeout() {
        return this.failOnTimeout;
    }

    public void setFailOnTimeout(boolean failOnTimeout) {
        this.failOnTimeout = failOnTimeout;
    }
}

