/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.conf.DumpDirOption;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.FactHandle;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.api.IDroolsWorkingMemory;

public abstract class AbstractDroolsWorkingMemory
implements IDroolsWorkingMemory {
    private static Logger logger = null;
    protected Thread thread = null;
    protected volatile StatefulKnowledgeSession knowledgeSession = null;
    protected ClassLoader classLoader;
    protected KnowledgeBase knowledgeBase;
    protected volatile DroolsWorkingMemoryState state;
    protected KnowledgeBuilderConfiguration knowledgeBuilderConf;
    private static int SLEEP_TIME_BETWEEN_FIRE = 500;
    private final Object monitor = new Object();

    protected AbstractDroolsWorkingMemory(Logger logger) {
        AbstractDroolsWorkingMemory.logger = logger;
        this.state = DroolsWorkingMemoryState.IDLE;
    }

    protected void initKnowledgeBuilderConfiguration(ClassLoader classLoader) {
        Properties props = new Properties();
        props.setProperty("drools.dialect.java.compiler", "JANINO");
        this.knowledgeBuilderConf = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(props, classLoader);
        if (Boolean.getBoolean("jonas.developer")) {
            File dumpDir = new File(System.getProperty("java.io.tmpdir"), "drools_dump");
            boolean exists = dumpDir.exists();
            if (!exists) {
                exists = dumpDir.mkdir();
            }
            if (exists && dumpDir.isDirectory()) {
                this.debug("WorkingMemory[<name>] Drools dump directory set to {0}", dumpDir);
                this.knowledgeBuilderConf.setOption(DumpDirOption.get(dumpDir));
            }
        }
    }

    @Override
    public void stop() {
        this.stop(DroolsWorkingMemoryState.STOPPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(DroolsWorkingMemoryState state) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.knowledgeSession != null) {
                this.knowledgeSession.dispose();
            }
        }
        this.knowledgeSession = null;
        if (this.thread != null) {
            try {
                this.thread.join(SLEEP_TIME_BETWEEN_FIRE);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (this.thread.isAlive()) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        DroolsWorkingMemoryState newState = state == DroolsWorkingMemoryState.IDLE || state == DroolsWorkingMemoryState.STOPPED ? state : DroolsWorkingMemoryState.STOPPED;
        this.debug("WorkingMemory[<name>] Stopped. State changed from {0} to {1}", new Object[]{this.state, newState});
        this.state = newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactHandle insert(Object fact) {
        if (this.isReady()) {
            Object object = this.monitor;
            synchronized (object) {
                this.debug("WorkingMemory[<name>] Inserting fact into session.", new Object[0]);
                return this.knowledgeSession.insert(fact);
            }
        }
        this.debug("WorkingMemory[<name>] Cannot insert fact into session: not RUNNING or no session.", new Object[0]);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(FactHandle handle, Object object) {
        if (this.isReady()) {
            Object object2 = this.monitor;
            synchronized (object2) {
                this.debug("WorkingMemory[<name>] Updating fact into session.", new Object[0]);
                this.knowledgeSession.update(handle, object);
            }
        } else {
            this.debug("WorkingMemory[<name>] Cannot update fact into session: not RUNNING or no session.", new Object[0]);
        }
    }

    private boolean isReady() {
        return this.state != DroolsWorkingMemoryState.STOPPED && this.knowledgeSession != null;
    }

    protected void createWorkingMemory() {
        this.debug("WorkingMemory[<name>] Create the KnowledgeSession", new Object[0]);
        this.knowledgeSession = this.knowledgeBase.newStatefulKnowledgeSession();
    }

    protected void startRuleExecutor() {
        this.state = DroolsWorkingMemoryState.RUNNING;
        this.debug("WorkingMemory[<name>] State is now {0}", new Object[]{this.state});
        this.thread = new Thread((Runnable)new RuleExecutor(), "Rule-Executor");
        this.thread.start();
        this.debug("WorkingMemory[<name>] RuleExecutor thread has been started", new Object[0]);
    }

    @Override
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @Override
    public DroolsWorkingMemoryState getState() {
        return this.state;
    }

    @Override
    public KnowledgeBuilder newKnowledgeBuilder() {
        return KnowledgeBuilderFactory.newKnowledgeBuilder(this.knowledgeBuilderConf);
    }

    protected void debug(String message, Object ... vars) {
        logger.log(Level.FINE, message, vars);
    }

    private class RuleExecutor
    implements Runnable {
        private RuleExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (AbstractDroolsWorkingMemory.this.isReady()) {
                Object object = AbstractDroolsWorkingMemory.this.monitor;
                synchronized (object) {
                    try {
                        int fired = AbstractDroolsWorkingMemory.this.knowledgeSession.fireAllRules();
                        AbstractDroolsWorkingMemory.this.debug("WorkingMemory[<name>] # of fired rules: {0}", fired);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Exception during fireAllRules() - " + e.getMessage());
                    }
                }
                try {
                    Thread.sleep(SLEEP_TIME_BETWEEN_FIRE);
                }
                catch (InterruptedException e) {
                    logger.throwing(this.getClass().getSimpleName(), "run()", e);
                }
            }
            AbstractDroolsWorkingMemory.this.debug("WorkingMemory[<name>] Cleanly exiting the RuleExecutor thread", new Object[0]);
        }
    }
}

