/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.io.StringReader;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.osgi.framework.Bundle;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.AbstractPackageAdder;

public class DrlPackageAdder
extends AbstractPackageAdder
implements IPackageAdder {
    private static Logger logger = Logger.getLogger(DrlPackageAdder.class.getName());
    private final String packageName;
    private final String drlFile;

    public DrlPackageAdder(Bundle bundle, Map<String, Object> globals, String packageName, String drlFile) {
        super(bundle, globals);
        this.packageName = packageName;
        this.drlFile = drlFile;
    }

    public DrlPackageAdder(Bundle bundle, Map<String, Object> globals, String workingMemoryName, String packageName, String drlFile) {
        super(bundle, globals, workingMemoryName);
        this.packageName = packageName;
        this.drlFile = drlFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public void addPackage(KnowledgeBuilder builder, KnowledgeBase knowledgeBase) {
        StringReader drlFileReader = new StringReader(this.drlFile);
        builder.add(ResourceFactory.newReaderResource(drlFileReader), ResourceType.DRL);
        if (builder.hasErrors()) {
            logger.log(Level.WARNING, builder.getErrors().toString());
        }
        logger.log(Level.INFO, "Drl file loaded");
        knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
    }
}

