/**
 * JASMINe
 * Copyright (C) 2012 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dbfill;

public class JTEventConfig {

    String probeId;
    String mbean;
    String vName;
    // Period in second
    int period;
    // min, max and delta used to randomly compute the values
    int vMin;
    int vMax;
    int vDeltaNeg;
    int vDeltaPos;

    public JTEventConfig(String probeId, String mbean, String vName, int period, int vMin, int vMax, int vDeltaNeg, int vDeltaPos) {
        this.probeId = probeId;
        this.mbean = mbean;
        this.vName = vName;
        this.period = period;
        this.vMin = vMin;
        this.vMax = vMax;
        this.vDeltaNeg = vDeltaNeg;
        this.vDeltaPos = vDeltaPos;
    }

    public String getProbeId() {
        return probeId;
    }

    public String getMBean() {
        return mbean;
    }

    public String getVName() {
        return vName;
    }

    public int getPeriod() {
        return period;
    }

    public int getVMin() {
        return vMin;
    }

    public int getVMax() {
        return vMax;
    }

    public int getVDeltaNeg() {
        return vDeltaNeg;
    }

    public int getVDeltaPos() {
        return vDeltaPos;
    }

    public String toString() {
        String s = "(probeId = " + probeId + ", mbean = " + mbean + ", vName = " + vName + ", period = " + period + ", vMin = " + vMin + ", vMax = "
                + vMax + ", vDeltaNeg = " + vDeltaNeg + ", vDeltaPos = " + vDeltaPos + ")";
        return s;
    }

}
