/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dummyservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.ObjectName;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.ow2.jasmine.monitoring.tests.dummyservice.Basic;
import org.ow2.jasmine.monitoring.tests.dummyservice.IDummyService;
import org.ow2.jonas.jmx.JmxService;

public class DummyServiceImpl
implements IDummyService,
Pojo {
    private InstanceManager __IM;
    static final String JONAS_BASE_PROPERTY__NAME = "jonas.base";
    static final String CONF_FILE_PROPERTY__NAME = "dummy-mbeans.conf";
    static final String DEFAULT_PROPERTIES_FILE_NAME = "default-dummy-mbeans.properties";
    static final String DEFAULT_OBJNAME_DOMAIN_NAME = "jtests";
    static final String DEFAULT_CATEGORY_VALUE = "default";
    private boolean __Fconfig;
    private Properties config;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FmbeansList;
    private ArrayList<ObjectName> mbeansList;
    private boolean __Mstart;
    private boolean __Mstop;
    private boolean __MloadConfiguration;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;

    Properties __getconfig() {
        if (!this.__Fconfig) {
            return this.config;
        }
        return (Properties)this.__IM.onGet((Object)this, "config");
    }

    void __setconfig(Properties properties) {
        if (!this.__Fconfig) {
            this.config = properties;
            return;
        }
        this.__IM.onSet((Object)this, "config", (Object)properties);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    ArrayList __getmbeansList() {
        if (!this.__FmbeansList) {
            return this.mbeansList;
        }
        return (ArrayList)this.__IM.onGet((Object)this, "mbeansList");
    }

    void __setmbeansList(ArrayList arrayList) {
        if (!this.__FmbeansList) {
            this.mbeansList = arrayList;
            return;
        }
        this.__IM.onSet((Object)this, "mbeansList", (Object)arrayList);
    }

    public DummyServiceImpl() {
        this(null);
    }

    private DummyServiceImpl(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setconfig(new Properties());
        this.__setjmxService(null);
        this.__setmbeansList(new ArrayList());
    }

    public void start() throws Exception {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __start() throws Exception {
        System.out.println(">> Starting the dummy service ...");
        this.__setmbeansList(new ArrayList());
        this.loadConfiguration();
        System.out.println(">> Register the dummy-mbeans in the MBeanServer");
        String domain = this.__getconfig().getProperty("domain.name", DEFAULT_OBJNAME_DOMAIN_NAME);
        StringTokenizer mbList = new StringTokenizer(this.__getconfig().getProperty("mbeans.list", "").trim(), ",");
        while (mbList.hasMoreTokens()) {
            String mbName = mbList.nextToken().trim();
            String category = this.__getconfig().getProperty("mbean." + mbName + ".category", DEFAULT_CATEGORY_VALUE).trim();
            String csIncrement = this.__getconfig().getProperty("mbean." + mbName + ".increment", new Integer(1).toString()).trim();
            int cIncrement = Integer.parseInt(csIncrement);
            String csAmplitude = this.__getconfig().getProperty("mbean." + mbName + ".amplitude", new Integer(100).toString()).trim();
            int cAmplitude = Integer.parseInt(csAmplitude);
            String csStep = this.__getconfig().getProperty("mbean." + mbName + ".step", new Integer(5).toString()).trim();
            int cStep = Integer.parseInt(csStep);
            String sObjName = domain + ":type=Basic,category=" + category + ",name=" + mbName;
            try {
                Basic mbean = new Basic(cIncrement, cAmplitude, cStep);
                ObjectName objName = new ObjectName(sObjName);
                this.__getjmxService().registerMBean((Object)mbean, objName);
                this.__getmbeansList().add(objName);
                System.out.println("++ ObjectName = " + objName.toString());
                System.out.println("   MBean      = " + mbean.toString());
            }
            catch (Exception e) {
                System.out.println("== ERROR: Cannot register the mbean with name '" + sObjName + "' (" + e.toString() + ")");
            }
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __stop() throws Exception {
        System.out.println(">> Stoping the dummy service ...");
        for (ObjectName element : this.__getmbeansList()) {
            this.__getjmxService().unregisterMBean(element);
        }
    }

    private void loadConfiguration() {
        if (!this.__MloadConfiguration) {
            this.__loadConfiguration();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadConfiguration", new Object[0]);
            this.__loadConfiguration();
            this.__IM.onExit((Object)this, "loadConfiguration", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadConfiguration", throwable);
            throw throwable;
        }
    }

    private void __loadConfiguration() {
        InputStream fis = null;
        String confFileName = System.getProperty(CONF_FILE_PROPERTY__NAME);
        if (confFileName != null) {
            confFileName = System.getProperty(JONAS_BASE_PROPERTY__NAME) + File.separator + "conf" + File.separator + confFileName;
            try {
                fis = new FileInputStream(confFileName);
            }
            catch (Exception e) {
                System.out.println("** ERROR: Cannot find the configuration file '" + confFileName + "' ! (" + e.getMessage() + ")");
                fis = null;
            }
        }
        if (fis == null) {
            confFileName = DEFAULT_PROPERTIES_FILE_NAME;
            fis = this.getClass().getClassLoader().getResourceAsStream(confFileName);
        }
        if (fis == null) {
            System.out.println("** ERROR: Cannot find the configuration properties file !");
        } else {
            System.out.println(">> Configuration file used: " + confFileName);
            try {
                this.__getconfig().load(fis);
            }
            catch (IOException e) {
                System.out.println("** ERROR: exception when loading configuration properties file ! (" + e.getMessage() + ")");
            }
        }
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("config")) {
                this.__Fconfig = true;
            }
            if (set.contains("mbeansList")) {
                this.__FmbeansList = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("loadConfiguration")) {
                this.__MloadConfiguration = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

