/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.tests.dummyservice;

import org.ow2.jasmine.monitoring.tests.dummyservice.BasicMBean;

public class Basic
implements BasicMBean {
    public static final int DEFAULT_INCREMENT = 1;
    public static final int DEFAULT_AMPLITUDE = 100;
    public static final int DEFAULT_STEP = 5;
    private int cIncrement = 1;
    private int cAmplitude = 100;
    private int cStep = 5;
    private int vStep = 5;
    private int vIncremented = -1;
    private int vSinusoidal = -5;
    private long vTimestamp;

    public Basic(int increment, int amplitude, int step) {
        this.cIncrement = increment;
        this.cAmplitude = amplitude;
        this.cStep = step;
        this.vStep = step;
        this.vIncremented = -this.cIncrement;
        this.vSinusoidal = -this.cStep;
        this.vTimestamp = System.currentTimeMillis();
    }

    public int getCIncrement() {
        return this.cIncrement;
    }

    public synchronized void setCIncrement(int increment) {
        this.cIncrement = increment;
    }

    public int getCAmplitude() {
        return this.cAmplitude;
    }

    public synchronized void setCAmplitude(int amplitude) {
        this.cAmplitude = amplitude;
    }

    public int getCStep() {
        return this.cStep;
    }

    public synchronized void setCStep(int step) {
        this.cStep = step;
    }

    public String getVDescription() {
        return "Basic: incr=" + this.cIncrement + ", ampl=" + this.cAmplitude + ", step=" + this.cStep;
    }

    public synchronized int getVPeriod() {
        long ts = System.currentTimeMillis();
        int period = new Long(ts - this.vTimestamp).intValue() / 1000;
        this.vTimestamp = ts;
        return period;
    }

    public synchronized int getVIncremented() {
        this.vIncremented += this.cIncrement;
        return this.vIncremented;
    }

    public synchronized int getVSinusoidal() {
        this.vSinusoidal += this.vStep;
        if (StrictMath.abs(this.vSinusoidal) >= this.cAmplitude) {
            this.vStep *= -1;
        }
        return this.vSinusoidal;
    }

    public synchronized void reset() {
        this.vIncremented = -this.cIncrement;
        this.vSinusoidal = -this.cStep;
        this.vTimestamp = System.currentTimeMillis();
    }

    public String toString() {
        return "Basic(increment = " + this.cIncrement + ", amplitude = " + this.cAmplitude + ", step = " + this.cStep + ")";
    }
}

