/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: DummyServiceImpl.java 7518 2011-01-25 11:28:25Z joaninh $
 * --------------------------------------------------------------------------
 */

package org.ow2.jasmine.monitoring.tests.dummyservice;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

import javax.management.MBeanServer;
import javax.management.ObjectName;

import org.ow2.jonas.jmx.JmxService;

public class DummyServiceImpl implements IDummyService {

	static final String JONAS_BASE_PROPERTY__NAME = "jonas.base";
	static final String CONF_FILE_PROPERTY__NAME = "dummy-mbeans.conf";
	static final String DEFAULT_PROPERTIES_FILE_NAME = "default-dummy-mbeans.properties";

	static final String DEFAULT_OBJNAME_DOMAIN_NAME = "jtests";
	static final String DEFAULT_CATEGORY_VALUE = "default";

	private Properties config = new Properties();

    /**
     * JOnAS JMX Service reference.
     */
    private JmxService jmxService = null;

    /**
     * List of the ObjectName of registered mbeans
     */
    private ArrayList<ObjectName> mbeansList = new ArrayList<ObjectName>();

    public void start() throws Exception {
    	
		System.out.println(">> Starting the dummy service ...");
		 	
    	// Init the MBean list
    	mbeansList = new ArrayList<ObjectName>();
    	
		// Load the configuration
		loadConfiguration();
		
		// Register the dummy mbeans defined in the dummyservice configuration file
		System.out.println(">> Register the dummy-mbeans in the MBeanServer");
		String domain = config.getProperty("domain.name", DEFAULT_OBJNAME_DOMAIN_NAME);
		StringTokenizer mbList = new StringTokenizer(config.getProperty("mbeans.list", "").trim(), ",");
		
		while (mbList.hasMoreTokens()) {
			
			// Get the mbean configuration
			String mbName = mbList.nextToken().trim();
			String category = config.getProperty("mbean." + mbName + ".category", DEFAULT_CATEGORY_VALUE).trim();
			String csIncrement = config.getProperty("mbean." + mbName + ".increment", new Integer(Basic.DEFAULT_INCREMENT).toString()).trim();
			int cIncrement = Integer.parseInt(csIncrement);
			String csAmplitude = config.getProperty("mbean." + mbName + ".amplitude", new Integer(Basic.DEFAULT_AMPLITUDE).toString()).trim();
			int cAmplitude = Integer.parseInt(csAmplitude);
			String csStep = config.getProperty("mbean." + mbName + ".step", new Integer(Basic.DEFAULT_STEP).toString()).trim();
			int cStep = Integer.parseInt(csStep);
			
			// Create the bean and register it
			String sObjName = domain + ":type=Basic,category=" +category + ",name=" +  mbName;
			try {
				Basic mbean = new Basic(cIncrement, cAmplitude, cStep);
				ObjectName objName = new ObjectName(sObjName);
				jmxService.registerMBean(mbean, objName);
				mbeansList.add(objName);
				System.out.println("++ ObjectName = " + objName.toString());
				System.out.println("   MBean      = " + mbean.toString());
			} catch (Exception e) {
				System.out.println("== ERROR: Cannot register the mbean with name '" + sObjName + "' (" + e.toString() + (")"));
			}
		}
    }

    public void stop() throws Exception {
		System.out.println(">> Stoping the dummy service ...");
    	// Unregister the mbeans
        Iterator<ObjectName> itr = mbeansList.iterator();
        while (itr.hasNext()) {
          ObjectName element = itr.next();
          jmxService.unregisterMBean(element);
        }
    }
    
	private void loadConfiguration() {
		
		InputStream fis = null;
		
		String confFileName = System.getProperty(CONF_FILE_PROPERTY__NAME);
		if (confFileName != null) {
			// Get JONAS_BASE/conf/<the-name> configuration file
			confFileName = System.getProperty(JONAS_BASE_PROPERTY__NAME) + File.separator + "conf" + File.separator + confFileName;
			try {
			    fis = new FileInputStream(confFileName);
			} catch (Exception e) {
				System.out.println("** ERROR: Cannot find the configuration file '" + confFileName + "' ! (" + e.getMessage() + ")");
				fis = null;
			}
		}
		if (fis == null) {
			// Get the default configuration file
			confFileName = DEFAULT_PROPERTIES_FILE_NAME;
			fis = this.getClass().getClassLoader().getResourceAsStream(confFileName);
		}
	
		if (fis == null) {
			System.out.println("** ERROR: Cannot find the configuration properties file !");
		} else {
			// Load the configuration from a the properties file
			System.out.println(">> Configuration file used: " + confFileName);
			try {
				config.load(fis);
			} catch (IOException e) {
				System.out.println("** ERROR: exception when loading configuration properties file ! (" + e.getMessage() + ")");
			}
		}
	}
	
    /**
     * @param jmxService the jmxService to set
     */
    public void setJmxService(final JmxService jmxService) {
        this.jmxService = jmxService;
    }

}
