/**
 * JASMINe
 * Copyright (C) 2010 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: Basic.java 7569 2011-01-31 08:37:55Z joaninh $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.monitoring.tests.dummyservice;

/**
 * @author joaninh
 *
 */
public class Basic implements BasicMBean {
	
	static public final int DEFAULT_INCREMENT = 1;
	static public final int DEFAULT_AMPLITUDE = 100;
	static public final int DEFAULT_STEP = 5;
	
	private int cIncrement = DEFAULT_INCREMENT;
	private int cAmplitude = DEFAULT_AMPLITUDE;
	private int cStep = DEFAULT_STEP;
	private int vStep = DEFAULT_STEP;
	
	private int vIncremented = -DEFAULT_INCREMENT;
	private int vSinusoidal = -DEFAULT_STEP;
	private long vTimestamp;
		
	public Basic(final int increment, final int amplitude, final int step) {
		this.cIncrement = increment;
		this.cAmplitude = amplitude;
		this.cStep = step;
		this.vStep = step;
		
		this.vIncremented = -cIncrement;
		this.vSinusoidal = -cStep;
		this.vTimestamp = System.currentTimeMillis();
	}

	/* 
	 */
	public int getCIncrement() {
		return cIncrement;
	}

	/* 
	 */
	synchronized public void setCIncrement(int increment) {
		cIncrement = increment;
	}
	
	/* 
	 */
	public int getCAmplitude() {
		return cAmplitude;
	}

	/* 
	 */
	synchronized public void setCAmplitude(int amplitude) {
		cAmplitude = amplitude;
	}

	/* 
	 */
	public int getCStep() {
		return cStep;
	}

	/*
	 */
	synchronized public void setCStep(int step) {
		cStep = step;
	}

	/*
	 */
	public String getVDescription() {
		return ("Basic: " + "incr=" + cIncrement + ", ampl=" + cAmplitude + ", step=" + cStep);
	}

	/**
	 * Return the elapsed time since the previous getPeriod() call (time in second).
	 * (Note that for the first call, this is the elapsed time since the MBean creation).
	 */
	synchronized public int getVPeriod() {
		long ts = System.currentTimeMillis();
		int period = (new Long(ts - vTimestamp)).intValue() / 1000;
		vTimestamp = ts;
		return period;
	}

	/* 
	 */
	synchronized public int getVIncremented() {
		vIncremented += cIncrement;
		return vIncremented;
	}
	
	/* 
	 */
	synchronized public int getVSinusoidal() {
		vSinusoidal += vStep;
		if (StrictMath.abs(vSinusoidal) >= cAmplitude) {
			vStep = vStep * (-1);
		}
		return vSinusoidal;
	}

	/*
	 */
	synchronized public void reset() {
		vIncremented = -cIncrement;
		vSinusoidal = -cStep;
		vTimestamp = System.currentTimeMillis();
	}


	/*
	 */
	public String toString() {
		return ("Basic(" + "increment = " + cIncrement + ", amplitude = " + cAmplitude + ", step = " + cStep + ")");
	}
	
}
