/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.logs.beans;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;

public class JMSLogInterceptor {
    private static Logger logger = Logger.getLogger(JMSLogInterceptor.class.getName());

    @AroundInvoke
    public Object invoked(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Object returnedValue = context.proceed();
        if (method.getName().equals("addLogEntity")) {
            Connection connection = null;
            Session session = null;
            MessageProducer publisher = null;
            try {
                InitialContext initialContext = new InitialContext();
                TopicConnectionFactory connectionFactory = (TopicConnectionFactory)initialContext.lookup("TCF");
                Topic topic = (Topic)initialContext.lookup("JASMINeAlarmsTopic");
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 1);
                publisher = session.createProducer((Destination)topic);
                TextMessage message = session.createTextMessage();
                String text = returnedValue.toString();
                message.setText(text);
                publisher.send((Message)message);
            }
            catch (JMSException e) {
                logger.warning("Unable to send a JMS message: " + e.getMessage());
            }
            catch (NullPointerException e) {
                logger.warning("Unable to find a JMS object: " + e.getMessage());
            }
            try {
                if (publisher != null) {
                    publisher.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException e) {
                logger.warning("Unable to close a JMS object: " + e.getMessage());
            }
        }
        return returnedValue;
    }
}

