/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.beans;

import java.lang.reflect.Method;
import java.util.logging.Logger;

import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;

/**
 * Interceptor class for <code>LogInterface</code>.<br><br>
 * This intercepts method invocations in <code>LogInterface</code> objects in order to detect alarm logging.<br>
 * It sends messages through JMS to notify external interfaces.
 * 
 * @author Awa OUEDRAOGO
 * @author Laurent RUAUD
 */
public class JMSLogInterceptor {

	/** Logger **/
    private static Logger logger = Logger.getLogger(JMSLogInterceptor.class.getName());
	
//    /** Connection factory to connect to JMS */
//    @Resource(mappedName = "TCF")
//    private TopicConnectionFactory connectionFactory;
//    /** Topic on which will be sent the notifications */
//    @Resource(mappedName = "JASMINeAlarmsTopic")
//    private Topic topic;
    
    /**
     * Handles method invocations.
     * This notify the addition of a log on a JMS topic.
     * 
     * @param context the context around the invocation.
     * @return method's invocation result.
     * @throws Exception any exception that invocation may throw.
     */
    @AroundInvoke
    public Object invoked(final InvocationContext context) throws Exception {
        Method method = context.getMethod();
        
        Object returnedValue = context.proceed();

        if (method.getName().equals("addLogEntity")) {

        	Connection connection = null;
        	Session session = null;
        	MessageProducer publisher = null;
        	
        	try {
        	    
        	    InitialContext initialContext = new InitialContext();
                TopicConnectionFactory connectionFactory = (TopicConnectionFactory)initialContext.lookup("TCF");
                Topic topic = (Topic)initialContext.lookup("JASMINeAlarmsTopic");
        	    
    	        // Create JMS objects
            	connection = connectionFactory.createConnection();
            	session = connection.createSession(false, Session.AUTO_ACKNOWLEDGE);
    	        publisher = session.createProducer(topic);
                TextMessage message = session.createTextMessage();
                
                // Compose text
                String text = returnedValue.toString();
                message.setText(text);
                // Send message
                publisher.send(message);
                
        	} catch(JMSException e) {
    			logger.warning("Unable to send a JMS message: " + e.getMessage());
        	} catch(NullPointerException e) {
    			logger.warning("Unable to find a JMS object: " + e.getMessage());
        	}

    		try {
	            // Close JMS objects
	        	if(publisher != null) publisher.close();
	        	if(session != null) session.close();
	        	if(connection != null) connection.close();
    		} catch(JMSException e) {
    			logger.warning("Unable to close a JMS object: " + e.getMessage());
    		}
        }

        return returnedValue;
    }

}
