/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.logs.beans;

import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JMSLogInterceptor {
    private Log logger = LogFactory.getLog(this.getClass());

    @AroundInvoke
    public Object invoked(InvocationContext context) throws Exception {
        Method method = context.getMethod();
        Object returnedValue = context.proceed();
        if (method.getName().equals("addLogEntity")) {
            Connection connection = null;
            Session session = null;
            MessageProducer publisher = null;
            try {
                InitialContext initialContext = new InitialContext();
                TopicConnectionFactory connectionFactory = (TopicConnectionFactory)initialContext.lookup("TCF");
                Topic topic = (Topic)initialContext.lookup("JASMINeAlarmsTopic");
                connection = connectionFactory.createConnection();
                session = connection.createSession(false, 1);
                publisher = session.createProducer((Destination)topic);
                TextMessage message = session.createTextMessage();
                String text = returnedValue.toString();
                message.setText(text);
                publisher.send((Message)message);
            }
            catch (JMSException e) {
                this.logger.warn((Object)"Unable to send a JMS message: ", new Object[]{e.getMessage()});
            }
            catch (NullPointerException e) {
                this.logger.warn((Object)"Unable to send a JMS message: ", new Object[]{e.getMessage()});
            }
            try {
                if (publisher != null) {
                    publisher.close();
                }
                if (session != null) {
                    session.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (JMSException e) {
                this.logger.warn((Object)"Unable to close a JMS object: ", new Object[]{e.getMessage()});
            }
        }
        return returnedValue;
    }
}

