/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.beans;

import java.util.Date;

import org.objectweb.jasmine.rules.logs.util.DBException;

public interface LogInterfaceRulesRemote {

    /**
     * Adds a log message to the database
     * 
     * @param date
     *            the date of the log
     * @param level
     *            the level of the log : INFO, WARN, ALERT, ACTION
     * @param message
     *            the message of the log
     * @throws DBException
     */
    int addLogEntity(Date date, String level, String message)
            throws DBException;

    /**
     * Deletes all the logs before {@code date}
     * 
     * @param date
     * @throws DBException
     */
    void deleteMessageBeforeDate(Date date) throws DBException;

}
