/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.util;

import java.io.Serializable;
import java.util.Date;

/**
 * This class provides a POJO to handle JASMINe alarms. 
 * @author Laurent RUAUD
 */
public class AlarmLog implements Serializable {

    /** Generated serial number */
    private static final long serialVersionUID = -1380738850782990219L;
    
    /** The alarm id */
    private int id;
    /** The alarm date */
    private Date date;
    /** The alarm level */
    private String level;
    /** The alarm message */
    private String message;

    /**
     * Creates an alarm with the specified values.
     * @param id the alarm id.
     * @param date the alarm date.
     * @param level the alarm level.
     * @param message the alarm message.
     */
    public AlarmLog(int id, Date date, String level, String message) {
        this.id = id;
        this.level = level;
        this.date = date;
        this.message = message;
    }

    /**
     * Returns the alarm id.
     * @return the alarm id.
     */
    public int getId() {
        return id;
    }

    /**
     * Defines the alarm id.
     * @param id the id to set.
     */
    public void setId(int id) {
        this.id = id;
    }

    /**
     * Returns the alarm date.
     * @return the alarm date.
     */
    public Date getDate() {
        return date;
    }

    /**
     * Defines the alarm date.
     * @param date the date to set
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * Returns the alarm level.
     * @return the alarm level.
     */
    public String getLevel() {
        return level;
    }

    /**
     * Defines the alarm level.
     * @param level the level to set
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * Returns the alarm message.
     * @return the alarm message.
     */
    public String getMessage() {
        return message;
    }

    /**
     * Defines the alarm message.
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }
}
