/**
 * JASMINe
 * Copyright (C) 2007 SERLI Informatique
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.beans;

import java.util.List;

import org.objectweb.jasmine.rules.logs.util.AlarmLog;

/**
 * This interface defines method that can be used locally to retrieve alarms.<br><br>
 *  
 * @author Laurent RUAUD
 */
public interface LogInterfaceLocal {

    /**
     * Retrieves the alarm with the specified id.
     * 
     * @param id id of the alarm to be retrieved.
     * @return the alarm with the specified id or null if no alarms match the id.
     */
    AlarmLog getLog(int id);

    /**
     * Retrieves the last alarms.<br>
     * The maximum number of alarms to retrieve must be specified.
     * 
     * @param nb the maximum number of alarm to retrieve.
     * @return a list of alarms or an empty list if no alarms have been raised.
     */
    List<AlarmLog> getLastLogs(int nb);
    
    /**
     * Retrieves the alarms with an id contained in the specified range of id inclusive.
     * 
     * @param lowid the low threshold.
     * @param highid the high threshold.
     * @return a list of alarms or an empty list if no alarms match.
     */
    List<AlarmLog> getLogRange(int lowid, int highid);
    
}
