/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.beans;

import java.util.Date;
import java.util.List;

import org.objectweb.jasmine.rules.logs.util.AlarmLog;

/**
 * This interface defines method that can be used remotely to handle alarms.<br><br>
 */
public interface LogInterfaceRemote {

    /**
     * Retrieves the alarm with the specified id.
     * 
     * @param id id of the alarm to be retrieved.
     * @return the alarm with the specified id or null if no alarms match the id.
     */
    AlarmLog getLog(int id);

    /**
     * Retrieves all the alarms contained in the DB.<br>
     * 
     * @return a list of alarms or an empty list if no alarms have been raised.
     */
    List<AlarmLog> getAllLogs();
    
    /**
     * Retrieves the alarms matching the specified criteria.
     * All alarms which a level in the list and raised between provided dates will be returned. 
     * 
     * @param levels a list of levels.
     * @param startDate the lowest date.
     * @param endDate the highest date.
     * @return a list of alarms or an empty list if no alarms match.
     */
    List<AlarmLog> getLogRange(String[] levels, Date startDate, Date endDate);


    
    /**
     * Deletes the alarm with the specified id.
     * 
     * @param id id of the alarm to be deleted.
     */
    void delLog(int id);

    /**
     * Deletes all the alarms contained in the DB.<br>
     */
    void delAllLogs();
    
    /**
     * Deletes the alarms matching the specified criteria.
     * All alarms which a level in the list and raised between provided dates will be deleted. 
     * 
     * @param levels a list of levels.
     * @param startDate the lowest date.
     * @param endDate the highest date.
     */
    void delLogRange(String[] levels, Date startDate, Date endDate);
}
