/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.dispatcher;

import org.objectweb.jasmine.rules.Notification;
import org.objectweb.jasmine.rules.action.GenerateJMXNotification;
import org.objectweb.jasmine.rules.dispatcher.EventDispatcherManager;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.messages.JasmineEventNotificationMail;
import org.ow2.jasmine.monitoring.eventswitch.client.DispatcherContext;
import org.ow2.jasmine.monitoring.eventswitch.client.JasmineEventNotificationDispatcher;

public class NotificationDispatcher {
    private static EventDispatcherManager<DispatcherContext> manager = null;
    private static JasmineEventNotificationDispatcher processor = null;

    private NotificationDispatcher() {
    }

    public static void dispatchEvent(EventAction action, String endpoint, JasmineEventNotification notification) {
        if (endpoint != null && endpoint.length() > 0) {
            if (action == EventAction.SAVE_IN_DATABASE || action == EventAction.JMS_TOPIC) {
                NotificationDispatcher.dispatchEventToURI(endpoint, notification);
            } else if (action == EventAction.JMX_EXPORT) {
                NotificationDispatcher.exportEventAsJMXNotification(notification);
            }
        } else {
            NotificationDispatcher.dispatchEvent(action, notification);
        }
    }

    public static void dispatchEvent(EventAction action, JasmineEventNotification notification) {
        if (action == EventAction.SAVE_IN_DATABASE) {
            NotificationDispatcher.dispatchEventToURI("vm://JasmineEventNotificationEJB3Wrapper", notification);
        } else if (action == EventAction.JMS_TOPIC) {
            NotificationDispatcher.dispatchEventToURI("vm://jasmineNotificationToJMS", notification);
        } else if (action == EventAction.JMX_EXPORT) {
            NotificationDispatcher.exportEventAsJMXNotification(notification);
        }
    }

    private static void dispatchEventToURI(String URI, JasmineEventNotification notification) {
        if (manager == null && processor == null) {
            manager = new EventDispatcherManager();
            processor = new JasmineEventNotificationDispatcher();
            manager.setProcessor(processor);
        }
        DispatcherContext context = new DispatcherContext();
        context.setJasmineURI(URI);
        manager.setContext(context);
        try {
            context.start();
            manager.dispatchEvent(notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void exportEventAsJMXNotification(JasmineEventNotification eventNotification) {
        Notification notification = new Notification(eventNotification.getDate(), eventNotification.getLevel(), eventNotification.getMessage());
        GenerateJMXNotification.exportAsJMXNotification(notification);
    }

    public static void dispatchEvent(EventAction action, String endpoint, JasmineEventNotification notification, String fromAddress, String toAddress) {
        if (action == EventAction.SEND_MAIL) {
            if (endpoint != null && endpoint.length() > 0) {
                JasmineEventNotificationMail mailNotification = new JasmineEventNotificationMail(notification.getId(), notification.getDate(), notification.getLevel(), notification.getMessage(), notification.getStatus(), notification.getRule(), fromAddress, toAddress);
                NotificationDispatcher.dispatchEventToURI(endpoint, (JasmineEventNotification)mailNotification);
            } else {
                NotificationDispatcher.dispatchEvent(action, notification, fromAddress, toAddress);
            }
        }
    }

    public static void dispatchEvent(EventAction action, JasmineEventNotification notification, String fromAddress, String toAddress) {
        if (action == EventAction.SEND_MAIL) {
            JasmineEventNotificationMail mailNotification = new JasmineEventNotificationMail(notification.getId(), notification.getDate(), notification.getLevel(), notification.getMessage(), notification.getStatus(), notification.getRule(), fromAddress, toAddress);
            NotificationDispatcher.dispatchEventToURI("vm://NotificationMailcomponent", (JasmineEventNotification)mailNotification);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventAction {
        SEND_MAIL,
        SAVE_IN_DATABASE,
        JMX_EXPORT,
        JMS_TOPIC;

    }
}

