/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: Restart.java 4798 2009-08-07 12:30:47Z alitokmen $
 */
package org.objectweb.jasmine.rules.action.lib.jonas5;

/**
 * @author Jean-Pierre Poutcheu
 * This class restarts a specified JOnAS instance.
 * prerequisites : The server must be started.
 */
public class Restart extends Thread {

    /**
     * the jmx url of the server.
     */
    private String jmxURL = null;

    /**
     * constructor.
     * @param jmxURL the jmx url.
     */
    public Restart(String jmxURL) {
        this.jmxURL = jmxURL;
    }

    /**
     * This method is automatically call when the
     * thread is started.
     */
    public final void run() {
        StopStandBy stdBy = new StopStandBy(this.jmxURL);
        Start st = new Start(this.jmxURL);
        final int timeToWait = 1000; // 1000 milliseconds
        stdBy.start();

        try {
            // wait until the end of StandBy process
            stdBy.join();
            Thread.sleep(timeToWait);

            System.out.println("JOnAS server stopped");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }

        System.out.println(stdBy.isAlive());
        // StandBy process is finished
        // we can now restart the server
        st.start();

        try {
            // wait until the end of Start process
            st.join();
            System.out.println("JOnAS server restarted");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
     }

}
