/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: GenerateJMXNotification.java 4798 2009-08-07 12:30:47Z alitokmen $
 */
package org.objectweb.jasmine.rules.action;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.objectweb.jasmine.rules.Notification;
import org.objectweb.jasmine.rules.logs.beans.JMXNotifier;

/**
 * @author Julien Legrand
 */
public class GenerateJMXNotification {

    /**
     * Get the remote object
     * @return JMXNotifier
     */
    protected static JMXNotifier getJMXNotificationFacade() {
        Context ctx = null;
        JMXNotifier jmx = null;
        try {
            ctx = new InitialContext();
            jmx = (JMXNotifier) ctx.lookup("jmx_notification_generator");

        } catch (NamingException e) {
            e.printStackTrace();
        }

        return jmx;
    }

    /**
     * Export the given notification as 'JMX notification'
     * @param notification the notification to export
     */
    public static void exportAsJMXNotification(Notification notification) {
        getJMXNotificationFacade().exportAsJMXNotification(notification);
    }

}
