/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: EventDispatcherManager.java 7496 2011-01-24 09:42:46Z renaultgu $
 */

package org.objectweb.jasmine.rules.dispatcher;

import org.ow2.jasmine.event.api.IJasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.processor.ProcessContext;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.jasmine.event.processor.JasmineEventNotificationProcessor;
import org.ow2.jasmine.event.processor.JasmineEventProcessorException;

public class EventDispatcherManager < T extends ProcessContext > {

    /**
     * Logger.
     */
    private static Log logger = LogFactory.getLog(EventDispatcherManager.class);

    /**
     * A JASMINe event notification processor.
     */
    private JasmineEventNotificationProcessor < T > processor;

    /**
     * A context for processing.
     */
    private T context;

    /**
     * @return a JASMINe event notification processor
     */
    public JasmineEventNotificationProcessor < T > getProcessor() {
        return processor;
    }

    /**
     * Set a JASMINe event notification processor.
     * @param processor a JASMINe event notification processor
     */
    public void setProcessor(final JasmineEventNotificationProcessor< T > processor) {
        this.processor = processor;
    }

    /**
     * @return a context for processing
     */
    public T getContext() {
        return context;
    }

    /**
     * Set a context for processing.
     * @param context a context for processing
     */
    public void setContext(final T context) {
        this.context = context;
    }

    public void dispatchEvent(IJasmineEventNotification jasmineEventNotification) {
        try {
            processor.process(context, jasmineEventNotification);
      }
      catch (JasmineEventProcessorException e) {
          logger.warn("Cannot process the notification event {0} with context {1}", jasmineEventNotification, context, e);
      }
    }
}

