/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.dispatcher;

import org.objectweb.jasmine.rules.Notification;
import org.objectweb.jasmine.rules.action.GenerateJMXNotification;
import org.objectweb.jasmine.rules.dispatcher.EventDispatcherManager;
import org.ow2.jasmine.event.api.IJasmineEventNotification;
import org.ow2.jasmine.event.beans.JasmineEventNotification;
import org.ow2.jasmine.event.messages.JasmineEventNotificationMail;
import org.ow2.jasmine.monitoring.eventswitch.client.DispatcherContext;
import org.ow2.jasmine.monitoring.eventswitch.client.JasmineEventNotificationDispatcher;

public class NotificationDispatcher {
    private static EventDispatcherManager<DispatcherContext> manager = null;
    private static JasmineEventNotificationDispatcher processor = null;

    private NotificationDispatcher() {
    }

    public static void dispatchEvent(EventAction action, JasmineEventNotification notification) {
        if (action == EventAction.SAVE_IN_DATABASE) {
            NotificationDispatcher.dispatchEvent("vm://JasmineEventNotificationEJB3Wrapper", (IJasmineEventNotification)notification);
        } else if (action == EventAction.JMS_TOPIC) {
            NotificationDispatcher.dispatchEvent("vm://JasmineNotificationJMSComponent", (IJasmineEventNotification)notification);
        } else if (action == EventAction.JMX_EXPORT) {
            NotificationDispatcher.exportEventAsJMXNotification(notification);
        } else {
            if (action == EventAction.SEND_MAIL) {
                throw new IllegalArgumentException("EventAction " + (Object)((Object)EventAction.SEND_MAIL) + " requires FROM_ADDRESS and TO_ADDRESS. Use " + NotificationDispatcher.class.getSimpleName() + ".dispatchEvent(" + EventAction.class.getSimpleName() + ", " + JasmineEventNotification.class.getSimpleName() + ", String, String) instead.");
            }
            throw new IllegalArgumentException("EventAction " + (Object)((Object)action) + " not supported!");
        }
    }

    public static void dispatchEvent(String URI, IJasmineEventNotification notification) {
        if (manager == null && processor == null) {
            manager = new EventDispatcherManager();
            processor = new JasmineEventNotificationDispatcher();
            manager.setProcessor(processor);
        }
        DispatcherContext context = new DispatcherContext();
        context.setJasmineURI(URI);
        manager.setContext(context);
        try {
            context.start();
            manager.dispatchEvent(notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void exportEventAsJMXNotification(JasmineEventNotification eventNotification) {
        Notification notification = new Notification(eventNotification.getDate(), eventNotification.getLevel(), eventNotification.getMessage());
        GenerateJMXNotification.exportAsJMXNotification(notification);
    }

    public static void dispatchEvent(String endpoint, JasmineEventNotification notification, String fromAddress, String toAddress) {
        JasmineEventNotificationMail mailNotification = new JasmineEventNotificationMail(notification.getId(), notification.getDate(), notification.getLevel(), notification.getMessage(), notification.getStatus(), notification.getRule(), fromAddress, toAddress);
        NotificationDispatcher.dispatchEvent(endpoint, (IJasmineEventNotification)mailNotification);
    }

    public static void dispatchEvent(EventAction action, JasmineEventNotification notification, String fromAddress, String toAddress) {
        if (action == EventAction.SEND_MAIL) {
            NotificationDispatcher.dispatchEvent("vm://JasmineEventNotificationMailWrapper", notification, fromAddress, toAddress);
        } else {
            NotificationDispatcher.dispatchEvent(action, notification);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventAction {
        SEND_MAIL,
        SAVE_IN_DATABASE,
        JMX_EXPORT,
        JMS_TOPIC;

    }
}

