/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: SendMail.java 4798 2009-08-07 12:30:47Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.action;

import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.mail.Message;
import javax.mail.MessageContext;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimePartDataSource;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.objectweb.jasmine.rules.logs.beans.LogInterfaceRulesRemote;

/**
 * @author Julien Legrand
 */
public class SendMail {

    /**
     * Mail Session used to send the Mail.
     */
    private Session mailSession;

    /**
     * Template for the message's content.
     */
    private MimePartDataSource mimePartDatasource;
    
    /**
     * 
     */
    public SendMail() {
        
        Context ctx = null;
        try {
            ctx = new InitialContext();
            mailSession = (Session) ctx.lookup("mailSession_1");
            mimePartDatasource = (MimePartDataSource) ctx.lookup("mailMimePartDS_1");
        } catch (NamingException e) {
            e.printStackTrace();
        }
        
    }


    public void sendWarningMail(final String log) {

        MessageContext context = mimePartDatasource.getMessageContext();
        Message message = context.getMessage();
        try {
            message.setContent(log, "text/plain");
        } catch (MessagingException e) {
            System.err.println("Cannot set message content:" + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }

        Transport transport = null;
        try {
            transport = mailSession.getTransport();
        } catch (NoSuchProviderException e) {
            e.printStackTrace(System.err);
            return;
        }
        try {
            transport.connect();
            transport.sendMessage(message, mimePartDatasource.getMessageContext().getMessage().getAllRecipients());
            transport.close();
        } catch (MessagingException e) {
            System.err.println("Cannot send message:" + e.getMessage());
            e.printStackTrace(System.err);
            return;
        }
    }

}
