/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: StopStandBy.java 4798 2009-08-07 12:30:47Z alitokmen $
 */
package org.objectweb.jasmine.rules.action.lib.jonas5;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/**
 * @author Jean-Pierre Poutcheu
 * This class 'stand by' a specified JOnAS instance.
 * prerequisites : The server must be started.
 */
public class StopStandBy extends Thread {

    /**
     * The MBean server.
     */
    private MBeanServerConnection mbscnx = null;

    /**
     * the jmx url of the server.
     */
    private String jmxURL = null;

    /**
     * constructor.
     * @param jmxURL the jmx url
     */
    public StopStandBy(String jmxURL) {
        this.jmxURL = jmxURL;
    }

    /**
     * This method is automatically call when the
     * thread is started.
     */
    public final void run() {
        if (this.mbscnx == null) {

            Map< String, Object > env = new HashMap< String, Object >();

            try {
                // create an RMI Connector
                JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(jmxURL), env);
                this.mbscnx = c.getMBeanServerConnection();
                // invoke the "stop" method 
                mbscnx.invoke(new ObjectName("jonas:j2eeType=J2EEServer,name=jonas"), "stop", new Object[0], new String[0]);
                } catch (InstanceNotFoundException e) {
                e.printStackTrace();
            } catch (MalformedObjectNameException e) {
                e.printStackTrace();
            } catch (MBeanException e) {
                e.printStackTrace();
            } catch (ReflectionException e) {
                e.printStackTrace();
            } catch (NullPointerException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            }

        }

     }

}
