/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.objectweb.jasmine.rules.action;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/**
 * @author Julien Legrand
 */
public class GenerateThreadDump {

    /**
     * 
     */
    private MBeanServerConnection mbscnx = null;

    /**
     * 
     */
    public GenerateThreadDump() {
    }


    public String generate(String url) {

        if (this.mbscnx == null) {

            Map<String, Object> env = new HashMap<String, Object>();

            // if (username != null && password != null) {
            // String[] creds = {username, password};
            // env.put(JMXConnector.CREDENTIALS, creds);
            // }

            try {

                JMXConnector c = JMXConnectorFactory.connect(new JMXServiceURL(url), env);
                this.mbscnx = c.getMBeanServerConnection();
                
            } catch (MalformedURLException e) {
                e.printStackTrace();
            } catch (IOException e) {
                e.printStackTrace();
            } catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        
        Object res = null;
        try {
            /*
             * FIXME generalize
             */
            res = mbscnx.invoke(new ObjectName("jonas:j2eeType=J2EEServer,name=jonas"), "getThreadStackDump", new Object[0], new String[0]);
        } catch (InstanceNotFoundException e) {
            e.printStackTrace();
        } catch (MalformedObjectNameException e) {
            e.printStackTrace();
        } catch (MBeanException e) {
            e.printStackTrace();
        } catch (ReflectionException e) {
            e.printStackTrace();
        } catch (NullPointerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        
        if(res != null){
            return res.toString();
        }

        return null;
    }

}
