/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id$
 */
package org.objectweb.jasmine.rules.action;

import  org.objectweb.jasmine.rules.action.lib.jonas5.Halt;
import  org.objectweb.jasmine.rules.action.lib.jonas5.Restart;
import  org.objectweb.jasmine.rules.action.lib.jonas5.Start;
import  org.objectweb.jasmine.rules.action.lib.jonas5.StopStandBy;

/**
 * @author Jean-Pierre Poutcheu
 */
public class JOnAS5Command {

    /**
     * default private constructor.
     */
    private JOnAS5Command() {
    }

    /**
     * stop some services on  the server.
     * @param jmxURL the jmx url
     */
    public static void stopStandby(final String jmxURL) {
        StopStandBy stopSb = new StopStandBy(jmxURL);
        // invoking the stop stand method on the server MBean
        stopSb.start();
    }


    /**
     * stop the server.
     * @param jmxURL the jmx url
     */
    public static void halt(final String jmxURL) {
        Halt halt = new Halt(jmxURL);
        // invoking the halt method on the server MBean
        halt.start();
    }


    /**
     * start the server.
     * @param jmxURL the jmx url
     */
    public static void start(final String jmxURL) {
        Start st = new Start(jmxURL);
        // invoking the start method on the server MBean
        st.start();
    }


    /**
     * restart the server.
     * @param jmxURL the jmx url
     */
    public static void restart(final String jmxURL) {
        Restart res = new Restart(jmxURL);
        // restarting the server
        res.start();
    }

}
