/**
 * JASMINe
 * Copyright (C) 2006-2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.action;

import java.util.Date;

import javax.ejb.EJB;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.objectweb.jasmine.rules.logs.beans.LogInterfaceRulesRemote;
import org.objectweb.jasmine.rules.logs.util.DBException;

public class LogConsequence {

    @EJB(beanName="log_interface")
    private LogInterfaceRulesRemote logInterfaceRules;
    
    public LogConsequence() {

        Context ctx = null;
        try {
            ctx = new InitialContext();
            logInterfaceRules = (LogInterfaceRulesRemote) ctx.lookup("log_interface");
        } catch (NamingException e) {
            e.printStackTrace();
        }

    }

    /**
     * Logs an alert message
     * 
     * @param message
     */
    public void logAlert(String message) {
        try {
            logInterfaceRules.addLogEntity(new Date(), "ALERT", message);
        } catch (DBException e) {
            e.printStackTrace();
        }
    }

    /**
     * Logs a warning message
     * 
     * @param message
     */
    public void logWarning(String message) {
        try {
            logInterfaceRules.addLogEntity(new Date(), "WARN", message);
        } catch (DBException e) {
            e.printStackTrace();
        }
    }

    /**
     * Logs an information message
     * 
     * @param message
     */
    public void logInfo(String message) {
        try {
            logInterfaceRules.addLogEntity(new Date(), "INFO", message);
        } catch (DBException e) {
            e.printStackTrace();
        }
    }

    /**
     * Logs an action message
     * 
     * @param message
     */
    public void logAction(String message) {
        try {
            logInterfaceRules.addLogEntity(new Date(), "ACTION", message);
        } catch (DBException e) {
            e.printStackTrace();
        }
    }
}
