/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: NotificationEB.java 4884 2009-08-12 14:19:51Z hant $
 */
package org.objectweb.jasmine.rules;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * Entity bean for a JASMINe notification
 * 
 * @author Julien Legrand
 */

@Entity
@Table(name = "JASMINE_NOTIFICATION")
public class NotificationEB {
    
    /**
     * Primary key.
     */
    private Long id;
    
    /**
     * 
     */
    @Column(name="dateStamp")
    private Date date;
    
    /**
     * 
     */
    @Column(name="levelDegree")
    private String level;
    
    /**
     * 
     */
    private String message;
    
    // ------------------------------------------------------------------------
    // Default constructor
    // ------------------------------------------------------------------------
    
    /**
     * 
     */
    public NotificationEB() {
    }
    
    // ------------------------------------------------------------------------
    // Getters & setters
    // ------------------------------------------------------------------------
    
    /**
     * @return Primary key
     */
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="JasmineNotifSeq")
    @SequenceGenerator(name="JasmineNotifSeq",sequenceName="JASMINE_NOTIF_SEQ", allocationSize=1)
    public Long getId() {
        return id;
    }
    
    /**
     * @param id Primary key
     */
    public void setId(final Long id) {
        this.id = id;
    }

    /**
     * @return the date
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="dateStamp")
    public Date getDate() {
        return date;
    }

    /**
     * @param date the date to set
     */
    @Column(name="dateStamp")
    public void setDate(Date date) {
        this.date = date;
    }

    /**
     * @return the level
     */
    @Column(name="levelDegree")
    public String getLevel() {
        return level;
    }

    /**
     * @param level the level to set
     */
    @Column(name="levelDegree")
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * @return the message
     */
    public String getMessage() {
        return message;
    }

    /**
     * @param message the message to set
     */
    public void setMessage(String message) {
        this.message = message;
    }

}
