/**
 * JASMINe
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * $Id: GenerateSNMPTrapSLB.java 4798 2009-08-07 12:30:47Z alitokmen $
 */
package org.objectweb.jasmine.rules.action;

import javax.ejb.Remote;
import javax.ejb.Stateless;

import org.objectweb.jasmine.rules.Notification;
import org.objectweb.jasmine.rules.logs.beans.SNMPTrapGenerator;

import org.ow2.jasmine.interfaces.snmp.alarms.SNMPAlarmMIB;

/**
 * @author Julien Legrand
 */

@Stateless(mappedName="snmp_trap_generator")
@Remote(SNMPTrapGenerator.class)
public class GenerateSNMPTrapSLB implements SNMPTrapGenerator {

    /**
     * {@inheritDoc}
     */
    public void exportAsSNMPTrap(Notification notification) {

        /*
         * TODO change SNMPAlarmMIB name and interface
         */
        SNMPAlarmMIB.getInstance().notifyAlarm(notification.getDate().getDate());

    }

}
