/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: LogEntity.java 7694 2011-02-04 14:24:04Z joaninh $
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.logs.impl;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "JM_LOGENTITY")
public class LogEntity implements Serializable {

    private static final long serialVersionUID = 2082496385877658216L;

    /**
     * The id is automatically generated
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private int logEntityId;

    /**
     * The date of the log
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name="dateStamp")
    private Date date;

    /**
     * The level of the log : INFO, WARN, ALERT, ACTION
     */
    @Column(name="levelDegree")
    private String level;

    /**
     * The message of the log
     */
    private String message;

    public LogEntity() {

    }

    public LogEntity(final Date date, final String level, final String message) {
        this();
        setDate(date);
        setLevel(level);
        setMessage(message);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public int getLogEntityId() {
        return logEntityId;
    }

    public void setLogEntityId(int logEntityId) {
        this.logEntityId = logEntityId;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

}
