/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.helpers;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractProbe implements Serializable {

    private final static String TIMESTAMP = "timestamp";

    private final static String HOSTNAME = "hostname";

    private final static String IP = "ip";

    protected Map<String, Object> attributes;

    public AbstractProbe(String timestamp, String hostname, String ip) {
        this();
        setTimestamp(timestamp);
        setHostname(hostname);
        setIp(ip);
    }

    public AbstractProbe() {
        this.attributes = new HashMap<String, Object>();
    }

    public String getHostname() {
        return (String) attributes.get(HOSTNAME);
    }

    public void setHostname(String hostname) {
        this.attributes.put(HOSTNAME, hostname);
    }

    public String getIp() {
        return (String) attributes.get(IP);
    }

    public void setIp(String ip) {
        this.attributes.put(IP, ip);
    }

    public long getTimestamp() {
        return (Long) attributes.get(TIMESTAMP);
    }

    public void setTimestamp(String timestamp) {
        this.attributes.put(TIMESTAMP, Long.valueOf(timestamp));
    }

    public Object getAttribute(String key) {
        return attributes.get(key);
    }
}
