/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.helpers;

public class CpuProbe extends AbstractProbe {

    /**
     * 
     */
    private static final long serialVersionUID = -6733694306088444114L;

    private final static String TOTAL = "totalCpu";

    private final static String NEW = "newCpu";

    private final static String SYSTEM = "systemCpu";

    private final static String IOWAIT = "iowaitCpu";

    public final static String USER = "userCpu";

    private final static String IDLE = "idleCpu";

    private final static String NICE = "niceCpu";

    public CpuProbe() {
        super();
    }

    public CpuProbe(String timestamp, String hostname, String ip,
            float totalCpu, float newCpu, float systemCpu, float ioWaitCpu,
            float userCpu, float idleCpu, float niceCpu) {
        super(timestamp, hostname, ip);

        setTotalCpu(totalCpu);
        setNewCpu(newCpu);
        setSystemCpu(systemCpu);
        setIoWaitCpu(ioWaitCpu);
        setUserCpu(userCpu);
        setIdleCpu(idleCpu);
        setNiceCpu(niceCpu);
    }

    public float getIdleCpu() {
        return (Float) getAttribute(IDLE);
    }

    public void setIdleCpu(float idleCpu) {
        attributes.put(IDLE, idleCpu);
    }

    public float getIoWaitCpu() {
        return (Float) getAttribute(IOWAIT);
    }

    public void setIoWaitCpu(float ioWaitCpu) {
        attributes.put(IOWAIT, ioWaitCpu);
    }

    public float getNewCpu() {
        return (Float) getAttribute(NEW);
    }

    public void setNewCpu(float newCpu) {
        attributes.put(NEW, newCpu);
    }

    public float getNiceCpu() {
        return (Float) getAttribute(NICE);
    }

    public void setNiceCpu(float niceCpu) {
        attributes.put(NICE, niceCpu);
    }

    public float getSystemCpu() {
        return (Float) getAttribute(SYSTEM);
    }

    public void setSystemCpu(float systemCpu) {
        attributes.put(SYSTEM, systemCpu);
    }

    public float getTotalCpu() {
        return (Float) getAttribute(TOTAL);
    }

    public void setTotalCpu(float totalCpu) {
        attributes.put(TOTAL, totalCpu);
    }

    public float getUserCpu() {
        return (Float) getAttribute(USER);
    }

    public void setUserCpu(float userCpu) {
        attributes.put(USER, userCpu);
    }

    public String toString() {
        return new String("CpuProbe[" + getTimestamp() + ", " + getHostname()
                + "] = " + getUserCpu());
    }

}
/*
 * <probe timestamp="1154606362850" hostname="frecb000707.frec.bull.fr"
 * ip="129.183.91.53"> <name>cpu</name> <method> <name>getData</name> <value>
 * <ProcStats> <Total>7.92</Total> <New>0</New> <System>0.99</System>
 * <IOWait>0</IOWait> <User>6.93</User> <Idle>92.08</Idle> <Nice>0</Nice>
 * </ProcStats> </value> </method> </probe>
 */
