/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.probes.helpers;

import org.objectweb.jasmine.rules.probes.helpers.AbstractProbe;

public class CpuProbe
extends AbstractProbe {
    private static final long serialVersionUID = -6733694306088444114L;
    private static final String TOTAL = "totalCpu";
    private static final String NEW = "newCpu";
    private static final String SYSTEM = "systemCpu";
    private static final String IOWAIT = "iowaitCpu";
    public static final String USER = "userCpu";
    private static final String IDLE = "idleCpu";
    private static final String NICE = "niceCpu";

    public CpuProbe() {
    }

    public CpuProbe(String timestamp, String hostname, String ip, float totalCpu, float newCpu, float systemCpu, float ioWaitCpu, float userCpu, float idleCpu, float niceCpu) {
        super(timestamp, hostname, ip);
        this.setTotalCpu(totalCpu);
        this.setNewCpu(newCpu);
        this.setSystemCpu(systemCpu);
        this.setIoWaitCpu(ioWaitCpu);
        this.setUserCpu(userCpu);
        this.setIdleCpu(idleCpu);
        this.setNiceCpu(niceCpu);
    }

    public float getIdleCpu() {
        return ((Float)this.getAttribute(IDLE)).floatValue();
    }

    public void setIdleCpu(float idleCpu) {
        this.attributes.put(IDLE, Float.valueOf(idleCpu));
    }

    public float getIoWaitCpu() {
        return ((Float)this.getAttribute(IOWAIT)).floatValue();
    }

    public void setIoWaitCpu(float ioWaitCpu) {
        this.attributes.put(IOWAIT, Float.valueOf(ioWaitCpu));
    }

    public float getNewCpu() {
        return ((Float)this.getAttribute(NEW)).floatValue();
    }

    public void setNewCpu(float newCpu) {
        this.attributes.put(NEW, Float.valueOf(newCpu));
    }

    public float getNiceCpu() {
        return ((Float)this.getAttribute(NICE)).floatValue();
    }

    public void setNiceCpu(float niceCpu) {
        this.attributes.put(NICE, Float.valueOf(niceCpu));
    }

    public float getSystemCpu() {
        return ((Float)this.getAttribute(SYSTEM)).floatValue();
    }

    public void setSystemCpu(float systemCpu) {
        this.attributes.put(SYSTEM, Float.valueOf(systemCpu));
    }

    public float getTotalCpu() {
        return ((Float)this.getAttribute(TOTAL)).floatValue();
    }

    public void setTotalCpu(float totalCpu) {
        this.attributes.put(TOTAL, Float.valueOf(totalCpu));
    }

    public float getUserCpu() {
        return ((Float)this.getAttribute(USER)).floatValue();
    }

    public void setUserCpu(float userCpu) {
        this.attributes.put(USER, Float.valueOf(userCpu));
    }

    public String toString() {
        return new String("CpuProbe[" + this.getTimestamp() + ", " + this.getHostname() + "] = " + this.getUserCpu());
    }
}

