/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.CpuProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CpuParser {
    public CpuProbe createCpuProbe(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();
            if (nodeName.equals("timestamp")) {
                timestamp = attribute.getNodeValue();
            }
            if (nodeName.equals("hostname")) {
                hostname = attribute.getNodeValue();
            }
            if (!nodeName.equals("ip")) continue;
            ip = attribute.getNodeValue();
        }
        NodeList children = node.getChildNodes();
        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node procStats = value.getChildNodes().item(0);
        NodeList grandChildren = procStats.getChildNodes();
        Float totalCpu = null;
        Float newCpu = null;
        Float systemCpu = null;
        Float ioWaitCpu = null;
        Float userCpu = null;
        Float idleCpu = null;
        Float niceCpu = null;
        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();
            if (nameChild.equals("Total")) {
                totalCpu = Float.valueOf(tmp);
            }
            if (nameChild.equals("New")) {
                newCpu = Float.valueOf(tmp);
            }
            if (nameChild.equals("System")) {
                systemCpu = Float.valueOf(tmp);
            }
            if (nameChild.equals("IOWait")) {
                ioWaitCpu = Float.valueOf(tmp);
            }
            if (nameChild.equals("User")) {
                userCpu = Float.valueOf(tmp);
            }
            if (nameChild.equals("Idle")) {
                idleCpu = Float.valueOf(tmp);
            }
            if (!nameChild.equals("Nice")) continue;
            niceCpu = Float.valueOf(tmp);
        }
        return new CpuProbe(timestamp, hostname, ip, totalCpu.floatValue(), newCpu.floatValue(), systemCpu.floatValue(), ioWaitCpu.floatValue(), userCpu.floatValue(), idleCpu.floatValue(), niceCpu.floatValue());
    }
}

