/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.NetworkProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkParser {
    public NetworkProbe createNetworkProbe(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();
            if (nodeName.equals("timestamp")) {
                timestamp = attribute.getNodeValue();
            }
            if (nodeName.equals("hostname")) {
                hostname = attribute.getNodeValue();
            }
            if (!nodeName.equals("ip")) continue;
            ip = attribute.getNodeValue();
        }
        NodeList children = node.getChildNodes();
        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node netStatsSum = value.getChildNodes().item(0);
        NodeList grandChildren = netStatsSum.getChildNodes();
        Long txBytesNetwork = null;
        Long rxBytesNetwork = null;
        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();
            if (nameChild.equals("TxBytes")) {
                txBytesNetwork = Long.valueOf(tmp);
            }
            if (!nameChild.equals("RxBytes")) continue;
            rxBytesNetwork = Long.valueOf(tmp);
        }
        return new NetworkProbe(timestamp, hostname, ip, txBytesNetwork, rxBytesNetwork);
    }
}

