/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.helpers;

public class MemoryProbe extends AbstractProbe {

    /**
     * 
     */
    private static final long serialVersionUID = -4740453086162298727L;

    private final static String CACHED = "cachedMemory";

    private final static String SWAPUSED = "swapUsedMemory";

    private final static String MEMTOTAL = "memTotalMemory";

    private final static String SWAPUSEDPER = "swapUsedPerMemory";

    private final static String BUFFERS = "buffersMemory";

    private final static String MEMUSED = "memUsedMemory";

    private final static String SWAPTOTAL = "swapTotalMemory";

    private final static String MEMFREE = "memFreeMemory";

    private final static String SWAPFREE = "swapFreeMemory";

    private final static String MEMUSEDPER = "memUsedPerMemory";

    public MemoryProbe() {
        super();
    }

    public MemoryProbe(String timestamp, String hostname, String ip,
            long cachedMemory, long swapUsedMemory, long memTotalMemory,
            float swapUsedPerMemory, long buffersMemory, long memUsedMemory,
            long swapTotalMemory, long memFreeMemory, long swapFreeMemory,
            float memUsedPerMemory) {
        super(timestamp, hostname, ip);

        setCachedMemory(cachedMemory);
        setSwapUsedMemory(swapUsedMemory);
        setMemTotalMemory(memTotalMemory);
        setSwapUsedPerMemory(swapUsedPerMemory);
        setBuffersMemory(buffersMemory);
        setMemUsedMemory(memUsedMemory);
        setSwapTotalMemory(swapTotalMemory);
        setMemFreeMemory(memFreeMemory);
        setSwapFreeMemory(swapFreeMemory);
        setMemUsedPerMemory(memUsedPerMemory);
    }

    public long getBuffersMemory() {
        return (Long) getAttribute(BUFFERS);
    }

    public void setBuffersMemory(long buffersMemory) {
        attributes.put(BUFFERS, buffersMemory);
    }

    public long getCachedMemory() {
        return (Long) getAttribute(CACHED);
    }

    public void setCachedMemory(long cachedMemory) {
        attributes.put(CACHED, cachedMemory);
    }

    public long getMemFreeMemory() {
        return (Long) getAttribute(MEMFREE);
    }

    public void setMemFreeMemory(long memFreeMemory) {
        attributes.put(MEMFREE, memFreeMemory);
    }

    public long getMemTotalMemory() {
        return (Long) getAttribute(MEMTOTAL);
    }

    public void setMemTotalMemory(long memTotalMemory) {
        attributes.put(MEMTOTAL, memTotalMemory);
    }

    public long getMemUsedMemory() {
        return (Long) getAttribute(MEMUSED);
    }

    public void setMemUsedMemory(long memUsedMemory) {
        attributes.put(MEMUSED, memUsedMemory);
    }

    public float getMemUsedPerMemory() {
        return (Float) getAttribute(MEMUSEDPER);
    }

    public void setMemUsedPerMemory(float memUsedPerMemory) {
        attributes.put(MEMUSEDPER, memUsedPerMemory);
    }

    public long getSwapFreeMemory() {
        return (Long) getAttribute(SWAPFREE);
    }

    public void setSwapFreeMemory(long swapFreeMemory) {
        attributes.put(SWAPFREE, swapFreeMemory);
    }

    public long getSwapTotalMemory() {
        return (Long) getAttribute(SWAPTOTAL);
    }

    public void setSwapTotalMemory(long swapTotalMemory) {
        attributes.put(SWAPTOTAL, swapTotalMemory);
    }

    public long getSwapUsedMemory() {
        return (Long) getAttribute(SWAPUSED);
    }

    public void setSwapUsedMemory(long swapUsedMemory) {
        attributes.put(SWAPUSED, swapUsedMemory);
    }

    public float getSwapUsedPerMemory() {
        return (Float) getAttribute(SWAPUSEDPER);
    }

    public void setSwapUsedPerMemory(float swapUsedPerMemory) {
        attributes.put(SWAPUSEDPER, swapUsedPerMemory);
    }

    public String toString() {
        return new String("MemoryProbe[" + getTimestamp() + ", "
                + getHostname() + "] = " + getMemUsedPerMemory());
    }
}

/*
 * <probe timestamp="1156171423767" hostname="frecb000707.frec.bull.fr"
 * ip="129.183.91.53"> <name>memory</name> <method> <name>getData</name>
 * <value> <MemStats> <Cached>110176</Cached> <SwapUsed>370800</SwapUsed>
 * <MemTotal>516608</MemTotal> <SwapUsedPer>40.14</SwapUsedPer> <Buffers>2792</Buffers>
 * <MemUsed>489920</MemUsed> <SwapTotal>923696</SwapTotal> <MemFree>26688</MemFree>
 * <SwapFree>552896</SwapFree> <MemUsedPer>94.83</MemUsedPer> </MemStats>
 * </value> </method> </probe>
 */