/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.MemoryProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MemoryParser {

    /**
     * Creates a MemoryProbe from a node
     * 
     * @param node
     *            a XML node
     * @return a MemoryProbe
     */
    public MemoryProbe createMemoryProbe(Node node) {

        NamedNodeMap namedNodeMap = node.getAttributes();
        // The attributes
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();

            if (nodeName.equals("timestamp"))
                timestamp = attribute.getNodeValue();

            if (nodeName.equals("hostname"))
                hostname = attribute.getNodeValue();

            if (nodeName.equals("ip")) {
                ip = attribute.getNodeValue();
            }
        }

        // The children nodes
        NodeList children = node.getChildNodes();

        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node MemStats = value.getChildNodes().item(0);
        NodeList grandChildren = MemStats.getChildNodes();

        Long cachedMemory = null;
        Long swapUsedMemory = null;
        Long memTotalMemory = null;
        Float swapUsedPerMemory = null;
        Long buffersMemory = null;
        Long memUsedMemory = null;
        Long swapTotalMemory = null;
        Long memFreeMemory = null;
        Long swapFreeMemory = null;
        Float memUsedPerMemory = null;

        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();

            if (nameChild.equals("Cached"))
                cachedMemory = Long.valueOf(tmp);

            if (nameChild.equals("SwapUsed"))
                swapUsedMemory = Long.valueOf(tmp);

            if (nameChild.equals("MemTotal"))
                memTotalMemory = Long.valueOf(tmp);

            if (nameChild.equals("SwapUsedPer"))
                swapUsedPerMemory = Float.valueOf(tmp);

            if (nameChild.equals("Buffers"))
                buffersMemory = Long.valueOf(tmp);

            if (nameChild.equals("MemUsed"))
                memUsedMemory = Long.valueOf(tmp);

            if (nameChild.equals("SwapTotal"))
                swapTotalMemory = Long.valueOf(tmp);

            if (nameChild.equals("MemFree"))
                memFreeMemory = Long.valueOf(tmp);

            if (nameChild.equals("SwapFree"))
                swapFreeMemory = Long.valueOf(tmp);

            if (nameChild.equals("MemUsedPer"))
                memUsedPerMemory = Float.valueOf(tmp);
        }

        return new MemoryProbe(timestamp, hostname, ip, cachedMemory,
                swapUsedMemory, memTotalMemory, swapUsedPerMemory,
                buffersMemory, memUsedMemory, swapTotalMemory, memFreeMemory,
                swapFreeMemory, memUsedPerMemory);
    }

}

/*
 * <probe timestamp="1156171423767" hostname="frecb000707.frec.bull.fr"
 * ip="129.183.91.53"> <name>memory</name> <method> <name>getData</name>
 * <value> <MemStats> <Cached>110176</Cached> <SwapUsed>370800</SwapUsed>
 * <MemTotal>516608</MemTotal> <SwapUsedPer>40.14</SwapUsedPer> <Buffers>2792</Buffers>
 * <MemUsed>489920</MemUsed> <SwapTotal>923696</SwapTotal> <MemFree>26688</MemFree>
 * <SwapFree>552896</SwapFree> <MemUsedPer>94.83</MemUsedPer> </MemStats>
 * </value> </method> </probe>
 */