/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.parsers;

import java.io.StringReader;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;

import org.xml.sax.InputSource;

public class ParserProbe {

    /**
     * Evaluates a XML stream
     * 
     * @param xml
     * @param expression
     * @param retour
     * @return
     */
    public Object evaluateSAX(String xml, String expression, QName retour) {
        try {
            System
                    .setProperty(
                            "javax.xml.xpath.XPathFactory:http://java.sun.com/jaxp/xpath/dom",
                            "com.sun.org.apache.xpath.internal.jaxp.XPathFactoryImpl");

            // Create the source
            InputSource source = new InputSource(new StringReader(xml));

            // Create XPath
            XPathFactory fabrique = XPathFactory.newInstance();
            XPath xpath = fabrique.newXPath();

            // Evaluate the expression
            XPathExpression exp = xpath.compile(expression);
            Object resultat = exp.evaluate(source, retour);
            return resultat;

        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

}
