/**
 * JASMINe
 * Copyright (C) 2006 Bull S.A.S.
 * Contact: jasmine@objectweb.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id:$
 * --------------------------------------------------------------------------
 */

package org.objectweb.jasmine.rules.probes.parsers;

import org.objectweb.jasmine.rules.probes.helpers.CpuProbe;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CpuParser {

    /**
     * Creates a CpuProbe from a node
     * 
     * @param node
     *            an XML node
     * @return a CpuProbe
     */
    public CpuProbe createCpuProbe(Node node) {

        NamedNodeMap namedNodeMap = node.getAttributes();
        // The attributes
        String timestamp = null;
        String hostname = null;
        String ip = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node attribute = namedNodeMap.item(i);
            String nodeName = attribute.getNodeName();

            if (nodeName.equals("timestamp"))
                timestamp = attribute.getNodeValue();

            if (nodeName.equals("hostname"))
                hostname = attribute.getNodeValue();

            if (nodeName.equals("ip")) {
                ip = attribute.getNodeValue();
            }
        }

        // The children nodes
        NodeList children = node.getChildNodes();

        Node method = children.item(1);
        Node value = method.getChildNodes().item(1);
        Node procStats = value.getChildNodes().item(0);
        NodeList grandChildren = procStats.getChildNodes();

        Float totalCpu = null;
        Float newCpu = null;
        Float systemCpu = null;
        Float ioWaitCpu = null;
        Float userCpu = null;
        Float idleCpu = null;
        Float niceCpu = null;

        for (int i = 0; i < grandChildren.getLength(); ++i) {
            Node grandChild = grandChildren.item(i);
            String nameChild = grandChild.getNodeName();
            String tmp = grandChild.getTextContent();

            if (nameChild.equals("Total"))
                totalCpu = Float.valueOf(tmp);

            if (nameChild.equals("New"))
                newCpu = Float.valueOf(tmp);

            if (nameChild.equals("System"))
                systemCpu = Float.valueOf(tmp);

            if (nameChild.equals("IOWait"))
                ioWaitCpu = Float.valueOf(tmp);

            if (nameChild.equals("User"))
                userCpu = Float.valueOf(tmp);

            if (nameChild.equals("Idle"))
                idleCpu = Float.valueOf(tmp);

            if (nameChild.equals("Nice"))
                niceCpu = Float.valueOf(tmp);
        }

        return new CpuProbe(timestamp, hostname, ip, totalCpu, newCpu,
                systemCpu, ioWaitCpu, userCpu, idleCpu, niceCpu);
    }

}
/*
 * <probe timestamp="1154606362850" hostname="frecb000707.frec.bull.fr"
 * ip="129.183.91.53"> <name>cpu</name> <method> <name>getData</name> <value>
 * <ProcStats> <Total>7.92</Total> <New>0</New> <System>0.99</System>
 * <IOWait>0</IOWait> <User>6.93</User> <Idle>92.08</Idle> <Nice>0</Nice>
 * </ProcStats> </value> </method> </probe>
 */